<?php 
include 'auth_check.php'; 
include 'db_connect.php'; 
$conn->set_charset('utf8mb4');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>All Complaints</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <div class="container mt-4">
    <div class="d-flex justify-content-between">
      <h4>সকল অভিযোগ</h4>
      <a href="index.php" class="btn btn-sm btn-outline-secondary">← Back to Dashboard</a>
    </div>

    <form method="get" class="row g-2 mt-3">
      <div class="col-md-4">
        <input type="text" name="search_id" class="form-control" placeholder="অভিযোগ ID দ্বারা খুঁজুন">
      </div>
      <div class="col-md-4">
        <select name="status" class="form-select">
          <option value="">সব স্ট্যাটাস</option>
          <option value="pending">Pending</option>
          <option value="approved">Approved</option>
          <option value="rejected">Rejected</option>
          <option value="running">Running</option>
          <option value="complete">Complete</option>
        </select>
      </div>
      <div class="col-md-4">
        <button class="btn btn-primary w-100">ফিল্টার করুন</button>
      </div>
    </form>

    <table class="table table-bordered mt-4">
      <thead>
        <tr>
          <th>অভিযোগ ID</th>
          <th>নাম</th>
          <th>ফোন</th>
          <th>স্ট্যাটাস</th>
          <th>তারিখ</th>
          <th>অ্যাকশন</th>
        </tr>
      </thead>
      <tbody>
      <?php
        function getStatusBadgeClass($status) {
          switch($status) {
              case 'pending': return 'bg-warning';
              case 'approved': return 'bg-success';
              case 'rejected': return 'bg-danger';
              case 'running': return 'bg-primary';
              case 'complete': return 'bg-secondary';
              default: return 'bg-dark';
          }
        }

        $search = $_GET['search_id'] ?? '';
        $status = $_GET['status'] ?? '';

        $query = "SELECT * FROM complaints WHERE 1";
        if ($search != '') {
            $query .= " AND id = '" . $conn->real_escape_string($search) . "'";
        }
        if ($status != '') {
            $query .= " AND status = '" . $conn->real_escape_string($status) . "'";
        }

        $query .= " ORDER BY created_at DESC";
        $result = $conn->query($query);

        if ($result->num_rows > 0) {
          while ($row = $result->fetch_assoc()) {
              $badgeClass = getStatusBadgeClass($row['status']);
              echo "<tr>
              <td class='text-start col-2'>{$row['id']}</td>
              <td class='col-3'>{$row['name']}</td>
              <td class='col-2'>{$row['phone_number']}</td>
              <td class='text-center col-1'><span class='btn btn-sm text-bg-primary {$badgeClass}'>{$row['status']}</span></td>
              <td class='text-center col-2'>{$row['created_at']}</td>
              <td class='text-center col-2'><a href='view_complaint.php?id={$row['id']}' class='btn btn-sm btn-primary'>সম্পূর্ণ তথ্য দেখুন</a></td>
              </tr>";
          }
        } else {
          echo "<tr><td colspan='6' class='text-center text-danger'>কোন অভিযোগ পাওয়া যায়নি</td></tr>";
        }
        ?>
      </tbody>
    </table>
  </div>

  <script>
        function filterTable() {
            const input = document.getElementById("searchBox").value.toLowerCase();
            const rows = document.querySelectorAll("#fileTable tbody tr");

            rows.forEach(row => {
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(input) ? "" : "none";
            });
        }

        function toggleDark() {
            document.body.classList.toggle("dark");
            localStorage.setItem("darkMode", document.body.classList.contains("dark") ? "on" : "off");
        }

        window.onload = function () {
            if (localStorage.getItem("darkMode") === "on") {
                document.body.classList.add("dark");
            }
        };
  </script>

</body>
</html>