<?php
include 'auth_check.php'; 
include 'db_connect.php'; 
$conn->set_charset('utf8mb4');

// Initial setup
$search = "";
$status = "";
$condition = "WHERE 1";

// Pagination setup
$limit = 25; // প্রতি পেজে ২৫টি ইউজার
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Filter by search
if (isset($_GET['search'])) {
    $search = trim($_GET['search']);
    if ($search !== "") {
        $search = $conn->real_escape_string($search);
        $condition .= " AND (number LIKE '%$search%' OR referCode LIKE '%$search%')";
    }
}

// Filter by status
if (isset($_GET['status']) && $_GET['status'] !== '') {
    $status = $conn->real_escape_string($_GET['status']);
    $condition .= " AND is_verified = '$status'";
}

// Get total records count
$total_sql = "SELECT COUNT(*) AS total FROM sign_up $condition";
$total_result = $conn->query($total_sql);
$total_row = $total_result->fetch_assoc();
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $limit);

// Fetch current page data
$sql = "SELECT id, name, number, email, profile_pic_url, is_verified, wallet_balance, referCode 
        FROM sign_up $condition 
        ORDER BY id DESC 
        LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>সকল সদস্য</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            padding: 30px;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .search-box {
            text-align: center;
            margin-bottom: 20px;
        }
        .search-box input[type="text"] {
            padding: 10px;
            width: 250px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        .search-box button {
            padding: 10px 15px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }
        a.btn {
            background-color: #007bff;
            color: white;
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 14px;
        }
        a.btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>

<h2>সকল সদস্যের তালিকা</h2>
<a href="index.php" class="btn btn-sm btn-outline-secondary">← ড্যাশবোর্ডে ফিরে যান</a>

<div class="search-box">
    <form method="GET">
        <input type="text" name="search" placeholder="মোবাইল বা Refer ID লিখুন" value="<?php echo htmlspecialchars($search); ?>">
        <button type="submit">সার্চ করুন</button>
        <br><br>
        <select name="status" class="form-select w-auto d-inline">
          <option value="">সব স্ট্যাটাস</option>
          <option value="0" <?= $status==='0'?'selected':'' ?>>Unverified</option>
          <option value="1" <?= $status==='1'?'selected':'' ?>>Verified</option>
          <option value="2" <?= $status==='2'?'selected':'' ?>>Pending</option>
          <option value="3" <?= $status==='3'?'selected':'' ?>>Demo Verified</option>
          <option value="4" <?= $status==='4'?'selected':'' ?>>Suspend</option>
        </select>
        <button class="btn btn-primary">ফিল্টার করুন</button>
    </form>
</div>

<table>
    <tr>
        <th>ক্রমিক</th>
        <th>ছবি</th>
        <th>নাম</th>
        <th>মোবাইল</th>
        <th>রেফার কোড</th>
        <th>স্ট্যাটাস</th>
        <th>ওয়ালেট ব্যালান্স</th>
        <th>বিস্তারিত</th>
    </tr>

    <?php
    $serial = $offset + 1;
    if ($result->num_rows > 0):
        while($row = $result->fetch_assoc()):
    ?>
    <tr>
        <td><?= $serial++ ?></td>
        <td>
            <?php if (!empty($row['profile_pic_url'])): ?>
                <img src="<?= $row['profile_pic_url'] ?>" alt="Image">
            <?php else: ?>
                <span class="text-muted">ছবি নেই</span>
            <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($row['name']) ?></td>
        <td><?= htmlspecialchars($row['number']) ?></td>
        <td><?= htmlspecialchars($row['referCode']) ?></td>
        <td>
            <?php
                if ($row['is_verified'] == 0) echo '<span class="badge bg-danger">Unverified</span>';
                elseif ($row['is_verified'] == 1) echo '<span class="badge bg-success">Verified</span>';
                elseif ($row['is_verified'] == 2) echo '<span class="badge bg-warning">Pending</span>';
                elseif ($row['is_verified'] == 3) echo '<span class="badge bg-primary">Demo Verified</span>';
                else echo '<span class="badge bg-secondary">Suspend</span>';
            ?>
        </td>
        <td><?= number_format($row['wallet_balance'], 2) ?> ৳</td>
        <td><a class="btn" href="user_details.php?id=<?= $row['id'] ?>">বিস্তারিত দেখুন</a></td>
    </tr>
    <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="9" style="text-align:center; color:red;">কোনো তথ্য পাওয়া যায়নি।</td></tr>
    <?php endif; ?>

</table>

<!-- Pagination Section -->
<?php if ($total_pages > 1): ?>
<nav class="mt-4">
    <ul class="pagination justify-content-center">
        <?php if ($page > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?search=<?= urlencode($search) ?>&status=<?= $status ?>&page=<?= $page - 1 ?>">← পূর্ববর্তী</a>
            </li>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                <a class="page-link" href="?search=<?= urlencode($search) ?>&status=<?= $status ?>&page=<?= $i ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>

        <?php if ($page < $total_pages): ?>
            <li class="page-item">
                <a class="page-link" href="?search=<?= urlencode($search) ?>&status=<?= $status ?>&page=<?= $page + 1 ?>">পরবর্তী →</a>
            </li>
        <?php endif; ?>
    </ul>
</nav>
<?php endif; ?>

</body>
</html>
