<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$response = [];

$offer_id = $_POST['offer_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($offer_id)) {
    $query = "DELETE sim_offers WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $offer_id);

    if ($stmt->execute()) {
        $response = [
            'status' => 'success',
            'message' => 'Offer deleted successfully',
            'data' => [
                'offer_id' => $offer_id
            ]
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Failed to delete offer',
            'data' => null
        ];
    }
} else {
    $response = [
        'status' => 'error',
        'message' => 'Invalid data',
        'data' => null
    ];
}

echo json_encode($response);
?>