<?php
include 'auth_check.php';
include 'db_connect.php';
$conn->set_charset('utf8mb4');

if (!isset($_GET['id'])) {
    header('Location: all_complaints.php');
    exit;
}

$id = intval($_GET['id']);
$query = "SELECT * FROM complaints WHERE id = '$id'";
$result = $conn->query($query);

if ($result->num_rows == 0) {
    echo "<div class='alert alert-danger'>অভিযোগ খুঁজে পাওয়া যায়নি!</div>";
    exit;
}

$row = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $status = $_POST['status'];
    $reject_reason = isset($_POST['reject_reason']) ? $conn->real_escape_string($_POST['reject_reason']) : NULL;

    if ($status == 'rejected' && empty($reject_reason)) {
        echo "<div class='alert alert-danger text-center'>দয়া করে বাতিল করার কারণ লিখুন।</div>";
    } else {
        $updateQuery = "UPDATE complaints SET status = '" . $conn->real_escape_string($status) . "'";

        if ($status == 'rejected') {
            $updateQuery .= ", reject_reason = '$reject_reason'";
        } else {
            $updateQuery .= ", reject_reason = NULL";
        }

        $updateQuery .= " WHERE id = '$id'";
        $conn->query($updateQuery);
        header('Location: all_complaints.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>অভিযোগ আপডেট করুন</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function toggleRejectReason() {
        const status = document.getElementById('status').value;
        const reasonDiv = document.getElementById('reject_reason_div');
            if (status === 'rejected') {
                reasonDiv.style.display = 'table-row';
            } else {
                reasonDiv.style.display = 'none';
            }
        }

        window.addEventListener('DOMContentLoaded', toggleRejectReason);
    </script>
</head>
<body>
    <div class="container mt-4">
        <h4>অভিযোগ আপডেট করুন</h4>
        <form method="post">
            <table class="table table-bordered">
                <tr>
                    <th>অভিযোগ ID</th>
                    <td><?php echo $row['id']; ?></td>
                </tr>
                <tr>
                    <th>নাম</th>
                    <td><?php echo $row['name']; ?></td>
                </tr>
                <tr>
                    <th>ফোন নম্বর</th>
                    <td><?php echo $row['phone_number']; ?></td>
                </tr>
                <tr>
                    <th>বর্তমান স্ট্যাটাস</th>
                    <td>
                        <select name="status" id="status" class="form-select" onchange="toggleRejectReason()" required>
                            <option value="pending" <?php if ($row['status'] == 'pending') echo 'selected'; ?>>Pending</option>
                            <option value="approved" <?php if ($row['status'] == 'approved') echo 'selected'; ?>>Approved</option>
                            <option value="rejected" <?php if ($row['status'] == 'rejected') echo 'selected'; ?>>Rejected</option>
                            <option value="investigated" <?php if ($row['status'] == 'investigated') echo 'selected'; ?>>Investigated</option>
                            <option value="complete" <?php if ($row['status'] == 'complete') echo 'selected'; ?>>Complete</option>
                        </select>
                    </td>
                </tr>
                <tr id="reject_reason_div" style="display:none;">
                    <th>বাতিলের কারণ</th>
                    <td>
                        <textarea name="reject_reason" class="form-control" rows="3" style="width: 100%;"><?php echo isset($row['reject_reason']) ? htmlspecialchars($row['reject_reason']) : ''; ?></textarea>
                    </td>
                </tr>
            </table>

            <button type="submit" class="btn btn-primary">✅ আপডেট করুন</button>
            <a href="all_complaints.php" class="btn btn-secondary">← সকল অভিযোগ</a>
        </form>
    </div>
</body>
</html>
