<?php 
include 'auth_check.php'; 
include 'db_connect.php';
$conn->set_charset('utf8mb4');

// Total Balace 
$query = "SELECT SUM(wallet_balance) AS total_balance FROM sign_up";
$result = mysqli_query($conn, $query);
$row = mysqli_fetch_assoc($result);

$totalBalance = $row['total_balance'] ?? 0;

// বিভিন্ন স্ট্যাটাস অনুযায়ী গণনা
$total = $conn->query("SELECT id FROM sign_up")->num_rows;
$unverified = $conn->query("SELECT id FROM sign_up WHERE is_verified = '0'")->num_rows;
$verified = $conn->query("SELECT id FROM sign_up WHERE is_verified = '1'")->num_rows;
$pending = $conn->query("SELECT id FROM sign_up WHERE is_verified = '2'")->num_rows;
$demo_verified = $conn->query("SELECT id FROM sign_up WHERE is_verified = '3'")->num_rows;
$suspand = $conn->query("SELECT id FROM sign_up WHERE is_verified = '4'")->num_rows;

// verification_requests টেবিল থেকে Pending স্ট্যাটাসের ডেটা গোনা
$verification_result = $conn->query("SELECT * FROM verification_requests WHERE status = 'Pending'");
$verification_count = $verification_result->num_rows;

// money_requests টেবিল থেকে Pending স্ট্যাটাসের ডেটা গোনা
$money_requests_result = $conn->query("SELECT * FROM money_requests WHERE status = 'Pending'");
$money_requests_count = $money_requests_result->num_rows;

// withdraw_requests টেবিল থেকে Pending স্ট্যাটাসের ডেটা গোনা
$withdraw_requests_result = $conn->query("SELECT * FROM withdraw_requests WHERE status = 'Pending'");
$withdraw_requests_count = $withdraw_requests_result->num_rows;

// নতুন অভিযোগ চেক করার কোড
$query = "SELECT * FROM complaints WHERE status = 'pending'";
$result = $conn->query($query);
$pending_count = $result->num_rows;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    .notification-badge {
      position: absolute;
      top: -5px;
      right: -5px;
      background-color: red;
      color: white;
      border-radius: 50%;
      padding: 2px 6px;
      font-size: 12px;
    }
    .toast-container {
      position: fixed;
      top: 1rem;
      right: 1rem;
      z-index: 9999;
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">Admin Panel</a>
      <div class="position-relative">
        <button id="bellBtn" class="btn btn-outline-light position-relative">
          🔔
          <span id="bellBadge" class="notification-badge" style="display:none">!</span>
        </button>
        <a href="logout.php" class="btn btn-outline-light ms-2">Logout</a>
      </div>
    </div>
  </nav>

  <div class="toast-container">
    <div id="pendingToast" class="toast bg-warning text-dark" role="alert" data-bs-delay="5000">
      <div class="toast-header">
        <strong class="me-auto">ভেরিফিকেশন রিকোয়েস্ট</strong>
        <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
      </div>
      <div class="toast-body">
        নতুন Verification ইউজার রিকোয়েস্ট এসেছে!
      </div>
    </div>
    <div id="moneyToast" class="toast bg-warning text-dark" role="alert" data-bs-delay="5000">
      <div class="toast-header">
        <strong class="me-auto">এ্যাড মানি রিকোয়েস্ট</strong>
        <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
      </div>
      <div class="toast-body">
        নতুন Add Money রিকোয়েস্ট এসেছে!
      </div>
    </div>
    <div id="withdrawToast" class="toast bg-warning text-dark" role="alert" data-bs-delay="5000">
      <div class="toast-header">
        <strong class="me-auto">উইথড্র রিকোয়েস্ট</strong>
        <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
      </div>
      <div class="toast-body">
        নতুন Withdraw রিকোয়েস্ট এসেছে!
      </div>
    </div>
  </div>

  <div class="container mt-4">
    <h3>Welcome to Dashboard</h3>
    <div class="row mt-4">
      <div class="col-md-3">
        <!-- <a href="all_complaints.php" class="btn btn-primary w-100 mb-2 position-relative">
        সকল অভিযোগ
        <?php if ($pending_count > 0): ?>
            <span class="notification-badge"><?php echo $pending_count; ?></span>
        <?php endif; ?>
        </a>
        <a href="all_members.php" class="btn btn-secondary w-100 mb-2">সকল সদস্য</a> -->
        <a href="all_users.php" class="btn btn-primary w-100 mb-2">সকল ইউজার</a>
        <a href="upload_banners.php" class="btn btn-primary w-100 mb-2">🖼️ ব্যানার আপলোড করুন</a>
      </div>
      
      <div class="col-md-9">
        <!-- All Payment Start -->
        <h5>Total Amount Stats</h5>
        <div class="row row-cols-2 row-cols-md-1 g-3">
          <div class="col">
              <div class="card text-bg-primary shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">মোট টাকার পরিমান</h6>
                    <h3><?php echo $totalBalance; ?></h3>
                </div>
              </div>
          </div>

        </div>
        <!-- All Payment End -->
         
        <!-- User Stats Start -->
        <h5>Users Stats</h5>
        <div class="row row-cols-2 row-cols-md-3 g-3">
          
          <div class="col">
            <a href="all_users.php" style="text-decoration:none;">
              <div class="card text-bg-primary shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">মোট ইউজার এর সংখ্যা</h6>
                    <h3 id="total_user"><?php echo $total; ?></h3>
                </div>
              </div>
            </a>
          </div>

          <div class="col">
            <a href="all_users.php?status=0" style="text-decoration:none;">
              <div class="card text-bg-warning shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">Unverified</h6>
                    <h3 id="unverified_user"><?php echo $unverified; ?></h3>
                </div>
              </div>
            </a>
          </div>

          <div class="col">
            <a href="all_users.php?status=1" style="text-decoration:none;">
              <div class="card text-bg-success shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">Verified</h6>
                    <h3 id="verified_user"><?php echo $verified; ?></h3>
                </div>
              </div>
            </a>
          </div>

          <div class="col">
            <a href="all_users.php?status=2" style="text-decoration:none;">
              <div class="card text-bg-danger shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">Pending</h6>
                    <h3 id="pending_user"><?php echo $pending; ?></h3>
                </div>
              </div>
            </a>
          </div>

          <div class="col">
            <a href="all_users.php?status=3" style="text-decoration:none;">
              <div class="card text-bg-info shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">Demo Verified</h6>
                    <h3 id="demo_user"><?php echo $demo_verified; ?></h3>
                </div>
              </div>
            </a>
          </div>

          <div class="col">
            <a href="all_users.php?status=4" style="text-decoration:none;">
              <div class="card text-bg-dark shadow-sm">
                <div class="card-body">
                    <h6 class="card-title">Suspend</h6>
                    <h3 id="suspand_user"><?php echo $suspand; ?></h3>
                </div>
              </div>
            </a>
          </div>

        </div>

        <!-- User Stats End -->

        <!-- User Request Start -->
        <h5>Users Stats</h5>
        <div class="row row-cols-2 row-cols-md-3 g-3 mb-5">
          <div class="col">
              <a href="verification_requests.php" style="text-decoration: none;">
                <div class="card text-bg-primary shadow-sm">
                  <div class="card-body text-white">
                    <h6 class="card-title">Verification Request</h6>
                    <h3 id="verification_requests"><?php echo $verification_count; ?></h3>
                  </div>
                </div>
              </a>
          </div>

          <div class="col">
              <a href="money_request.php" style="text-decoration: none;">
                <div class="card text-bg-warning shadow-sm">
                  <div class="card-body">
                      <h6 class="card-title">Add Money Request</h6>
                      <h3 id="money_requests"><?php echo $money_requests_count; ?></h3>
                  </div>
                </div>
              </a>
          </div>

          <div class="col">
              <a href="withdraw_request.php" style="text-decoration: none;">
                <div class="card text-bg-success shadow-sm">
                  <div class="card-body">
                      <h6 class="card-title">Withdraw Request</h6>
                      <h3 id="withdraw_requests"><?php echo $withdraw_requests_count; ?></h3>
                  </div>
                </div>
              </a>
          </div>

        </div>

        <!-- User Request End -->

      </div>
    </div>
  </div>


  <script>
    let lastPendingCount = <?php echo $pending; ?>;
    let lastAddMoneyCount = <?php echo $money_requests_count; ?>;
    let lastWtihdarawCount = <?php echo $withdraw_requests_count; ?>;

    function fetchStats() {
      fetch('user_stats.php')
        .then(response => response.json())
        .then(data => {
          document.getElementById('total_user').innerText = data.total;
          document.getElementById('unverified_user').innerText = data.unverified;
          document.getElementById('verified_user').innerText = data.verified;
          document.getElementById('pending_user').innerText = data.pending;
          document.getElementById('demo_user').innerText = data.demo_verified;
          document.getElementById('suspand_user').innerText = data.suspand;

          document.getElementById('verification_requests').innerText = data.verification_requests;
          document.getElementById('money_requests').innerText = data.money_requests;
          document.getElementById('withdraw_requests').innerText = data.withdraw_requests;

          if (data.pending > lastPendingCount) {
            document.getElementById('bellBadge').style.display = 'inline';
            const toast = new bootstrap.Toast(document.getElementById('pendingToast'));
            toast.show();
          }

          if (data.money_requests > lastAddMoneyCount) {
            document.getElementById('bellBadge').style.display = 'inline';
            const toast = new bootstrap.Toast(document.getElementById('moneyToast'));
            toast.show();
          }

          if (data.withdraw_requests > lastWtihdarawCount) {
            document.getElementById('bellBadge').style.display = 'inline';
            const toast = new bootstrap.Toast(document.getElementById('withdrawToast'));
            toast.show();
          }

          lastPendingCount = data.pending;
          lastAddMoneyCount = data.money_requests;
          lastWtihdarawCount = data.withdraw_requests;
        });
    }

    setInterval(fetchStats, 5000); // প্রতি ৫ সেকেন্ডে একবার ডেটা আনবে
    fetchStats(); // প্রথমবারও কল করো
  </script>


</body>
</html>
