<?php
include 'auth_check.php';
include 'db_connect.php';
$conn->set_charset('utf8mb4');

// Pagination সেটিংস
$limit = 25;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// মোট রিকোয়েস্ট সংখ্যা
$total_result = $conn->query("SELECT COUNT(*) as total FROM money_requests WHERE status = 'Pending'");
$total_row = $total_result->fetch_assoc();
$total_requests = $total_row['total'];
$total_pages = ceil($total_requests / $limit);

// পেজ অনুযায়ী রিকোয়েস্ট আনছি
$sql = "SELECT mr.*, su.name, su.referCode FROM money_requests mr 
        JOIN sign_up su ON mr.user_id = su.id
        WHERE mr.status = 'Pending'
        ORDER BY mr.id DESC
        LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Money Requests</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background-color: #f8f9fa; }
    .card { border-radius: 12px; }
    .btn-sm { padding: 4px 12px; font-size: 14px; }
    a.btn {
      background-color: #007bff;
      color: white;
      padding: 6px 12px;
      border-radius: 5px;
      text-decoration: none;
      font-size: 14px;
    }
    a.btn:hover { background-color: #0056b3; }
    .table th, .table td { vertical-align: middle; }
    .pagination .page-link { font-size: 14px; }
  </style>
</head>
<body>

<div class="container mt-5">
  <div class="card shadow-sm">
    <a href="index.php" class="btn btn-sm btn-outline-secondary mb-4 mt-3 ms-3">← ড্যাশবোর্ডে ফিরে যান</a>

    <div class="card-header bg-primary text-white">
      <h5 class="mb-0">পেন্ডিং মানি রিকোয়েস্ট</h5>
    </div>

    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0 table-bordered align-middle">
          <thead class="table-light">
            <tr>
              <th>ক্রমিক</th>
              <th>এ্যফিলিয়েট আইডি</th>
              <th>ইউজারের নাম</th>
              <th>একাউন্ট নম্বর</th>
              <th>ট্রানজেকশন আইডি</th>
              <th>পরিমাণ (৳)</th>
              <th>পেমেন্ট গেটওয়ে</th>
              <th>অ্যাকশন</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($result->num_rows > 0): ?>
              <?php $serial = $offset + 1; ?>
              <?php while($row = $result->fetch_assoc()): ?>
                <tr>
                  <td><?= $serial++; ?></td>
                  <td><?= htmlspecialchars($row['referCode']); ?></td>
                  <td><?= htmlspecialchars($row['name']); ?></td>
                  <td><?= htmlspecialchars($row['account_number']); ?></td>
                  <td><?= htmlspecialchars($row['transaction_id']); ?></td>
                  <td><?= number_format($row['amount'], 2); ?> ৳</td>
                  <td><?= htmlspecialchars($row['payment_gateway']); ?></td>
                  <td>
                    <form action="update_money.php" method="post" class="d-flex gap-1">
                      <input type="hidden" name="id" value="<?= $row['id']; ?>">
                      <button name="action" value="Approved" class="btn btn-success btn-sm">Approve</button>
                      <button name="action" value="Rejected" class="btn btn-danger btn-sm">Reject</button>
                    </form>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="8" class="text-center text-muted">কোনো পেন্ডিং রিকোয়েস্ট পাওয়া যায়নি।</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Pagination -->
    <div class="card-footer text-center">
      <nav>
        <ul class="pagination justify-content-center mb-0">
          <?php if ($page > 1): ?>
            <li class="page-item"><a class="page-link" href="?page=<?= $page - 1; ?>">আগে</a></li>
          <?php endif; ?>

          <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= ($i == $page) ? 'active' : ''; ?>">
              <a class="page-link" href="?page=<?= $i; ?>"><?= $i; ?></a>
            </li>
          <?php endfor; ?>

          <?php if ($page < $total_pages): ?>
            <li class="page-item"><a class="page-link" href="?page=<?= $page + 1; ?>">পরেরটি</a></li>
          <?php endif; ?>
        </ul>
      </nav>
    </div>

  </div>
</div>

</body>
</html>
