<?php
include 'auth_check.php'; 
include 'db_connect.php';
$conn->set_charset('utf8mb4');
date_default_timezone_set("Asia/Dhaka");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $request_id = $_POST['id'];
    $action = $_POST['action'];
    $current_time = date("d-m-Y H:i:s");

    // ভেরিফিকেশন রিকোয়েস্ট বের করা
    $stmt = $conn->prepare("SELECT * FROM verification_requests WHERE id = ?");
    $stmt->bind_param("i", $request_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $request = $result->fetch_assoc();
        $user_id = $request['user_id'];
        $user_refer = $request['refer_id'];

        if ($action === 'Approved') {
            // ইউজার অ্যাপ্রুভ করা
            $stmt = $conn->prepare("UPDATE sign_up SET is_verified = 1, verified_at = ? WHERE id = ?");
            $stmt->bind_param("si", $current_time, $user_id);
            $stmt->execute();

            // নোটিফিকেশন
            $msg = "আপনার ভেরিফিকেশন সফল হয়েছে";
            $stmt = $conn->prepare("INSERT INTO notifications (user_id, message, created_at) VALUES (?, ?, ?)");
            $stmt->bind_param("iss", $user_id, $msg, $current_time);
            $stmt->execute();

            // রিকোয়েস্ট স্টেটাস আপডেট
            $stmt = $conn->prepare("UPDATE verification_requests SET status = 'Approved', updated_at = ? WHERE id = ?");
            $stmt->bind_param("si", $current_time, $request_id);
            $stmt->execute();

            // Referral Bonus হিসেব করা
            $stmt = $conn->prepare("SELECT referCode, referredBy FROM sign_up WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $referral_result = $stmt->get_result();

            if ($referral_result->num_rows > 0) {
                $user_data = $referral_result->fetch_assoc();
                $referCode = $user_data['referCode'];
                $referredBy = $user_data['referredBy'];

                // Bonus Function Call
                distributeReferralBonus($conn, $user_refer, $referredBy, $current_time);
            }

        } elseif ($action === 'Rejected') {
            // ইউজার রিজেক্ট করা
            $stmt = $conn->prepare("UPDATE sign_up SET is_verified = 0, verified_at = ? WHERE id = ?");
            $stmt->bind_param("si", $current_time, $user_id);
            $stmt->execute();

            // রিজেক্ট মেসেজ
            $msg = "আপনার ভেরিফিকেশন রিজেক্ট করা হয়েছে, অনুগ্রহ করে টাকা সেন্ড মানি করে সঠিক মোবাইল নাম্বার ও ট্রানজেশন আই.ডি দিন";
            $stmt = $conn->prepare("INSERT INTO notifications (user_id, message, created_at) VALUES (?, ?, ?)");
            $stmt->bind_param("iss", $user_id, $msg, $current_time);
            $stmt->execute();

            // রিকোয়েস্ট স্টেটাস আপডেট
            $stmt = $conn->prepare("UPDATE verification_requests SET status = 'Rejected', updated_at = ? WHERE id = ?");
            $stmt->bind_param("si", $current_time, $request_id);
            $stmt->execute();
        }
    }

    // Redirect
    header("Location: verification_requests.php");
    exit();
}

// ✅ Referral Bonus Function
function distributeReferralBonus($conn, $user_refer, $referredBy, $current_time) {
    $levels = [70, 30, 10, 5, 5, 5, 5]; // Level-wise bonus
    $current_level = 1;

    while ($current_level <= count($levels)) {
        if (!$referredBy) break;

        $stmt = $conn->prepare("SELECT id, referCode, referredBy FROM sign_up WHERE referCode = ?");
        $stmt->bind_param("s", $referredBy);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $upline_user_id = $row['id'];
            $upline_referCode = $row['referCode'];
            $upline_referredBy = $row['referredBy'];

            // ওয়ালেটে টাকা যোগ
            $bonus = $levels[$current_level - 1];
            $stmt = $conn->prepare("UPDATE sign_up SET wallet_balance = wallet_balance + ? WHERE referCode = ?");
            $stmt->bind_param("ds", $bonus, $upline_referCode);
            $stmt->execute();

            // ট্রানজেকশন রেকর্ড
            $description = "লেভেল $current_level এফিলিয়েট বোনাস যুক্ত হয়েছে";
            $stmt = $conn->prepare("INSERT INTO transactions (user_id, refer_id, amount, type, description, update_at) VALUES (?, ?, ?, 'commission', ?, ?)");
            $stmt->bind_param("isdss", $upline_user_id, $user_refer, $bonus, $description, $current_time);
            $stmt->execute();

            $referredBy = $upline_referredBy;
            $current_level++;
        } else {
            break;
        }
    }
}
?>
