<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");
header("Content-Type: application/json; charset=utf-8");

$request_id = $_POST['request_id'] ?? null;
$action = $_POST['action'] ?? null; // 'Approve' or 'Reject'
$current_time = $_POST['current_time'] ?? date("Y-m-d H:i:s"); // Default: Current time

$response = [];

if (isset($request_id) && isset($action)) {
    // Fetch request details
    $query = "SELECT * FROM verification_requests WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $request_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $request = $result->fetch_assoc();
        $user_id = $request['user_id'];
        $user_refer = $request['refer_id'];

        if ($action === 'Approve') {
            // Approve the request
            $update_user_query = "UPDATE sign_up SET is_verified = 1, verified_at = ? WHERE id = ?";
            $stmt_update_user = $conn->prepare($update_user_query);
            $stmt_update_user->bind_param("si", $current_time, $user_id);

            // Create a notification
            $notification_message = "আপনার ভেরিফিকেশন সফল হয়েছে";
            $notification_query = "INSERT INTO notifications (user_id, message, created_at) VALUES (?, ?, ?)";
            $notification_stmt = $conn->prepare($notification_query);
            $notification_stmt->bind_param("iss", $user_id, $notification_message, $current_time);
            $notification_stmt->execute();

            if ($stmt_update_user->execute()) {
                // Fetch referral code of user
                $fetch_referral_query = "SELECT referCode, referredBy FROM sign_up WHERE id = ?";
                $stmt_fetch_referral = $conn->prepare($fetch_referral_query);
                $stmt_fetch_referral->bind_param("i", $user_id);
                $stmt_fetch_referral->execute();
                $referral_result = $stmt_fetch_referral->get_result();

                if ($referral_result->num_rows > 0) {
                    $user_data = $referral_result->fetch_assoc();
                    $referCode = $user_data['referCode'];
                    $referredBy = $user_data['referredBy'];

                    // Distribute referral bonus
                    distributeReferralBonus($conn, $user_refer, $referredBy, $current_time);
                }

                // Update request status to 'Approved'
                $update_request_query = "UPDATE verification_requests SET status = 'Approved', updated_at = ? WHERE id = ?";
                $stmt_update_request = $conn->prepare($update_request_query);
                $stmt_update_request->bind_param("si", $current_time, $request_id);

                if ($stmt_update_request->execute()) {
                    $response['message'] = "ভেরিফিকেশন অ্যাপ্রুভ সফল";
                } else {
                    $response['message'] = "রিকোয়েস্ট আপডেট করা ব্যর্থ হয়েছে";
                }
            } else {
                $response['message'] = "ইউজার ভেরিফাই করা ব্যর্থ হয়েছে";
            }
        } elseif ($action === 'Reject') {
            // Reject the request
            $update_user_query = "UPDATE sign_up SET is_verified = 0, verified_at = ? WHERE id = ?";
            $stmt_update_user = $conn->prepare($update_user_query);
            $stmt_update_user->bind_param("si", $current_time, $user_id);

            // Create a notification
            $notification_message = "আপনার ভেরিফিকেশন রিজেক্ট করা হয়েছে, অনুগ্রহ করে টাকা সেন্ড মানি করে সঠিক মোবাইল নাম্বার ও ট্রানজেশন আই.ডি দিন";
            $notification_query = "INSERT INTO notifications (user_id, message, created_at) VALUES (?, ?, ?)";
            $notification_stmt = $conn->prepare($notification_query);
            $notification_stmt->bind_param("iss", $user_id, $notification_message, $current_time);
            $notification_stmt->execute();

            if ($stmt_update_user->execute()) {

                $update_request_query = "UPDATE verification_requests SET status = 'Rejected', updated_at = ? WHERE id = ?";
                $stmt_update_request = $conn->prepare($update_request_query);
                $stmt_update_request->bind_param("si", $current_time, $request_id);

                if ($stmt_update_request->execute()) {
                    $response['message'] = "ভেরিফিকেশন রিজেক্ট সফল";
                } else {
                    $response['message'] = "রিকোয়েস্ট আপডেট করা ব্যর্থ হয়েছে";
                }

            }

            
        } else {
            $response['message'] = "অবৈধ অ্যাকশন";
        }
    } else {
        $response['message'] = "রিকোয়েস্ট খুঁজে পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);

// ======= Referral Bonus System =======

function distributeReferralBonus($conn, $user_refer, $referredBy, $current_time) {
    $levels = [70, 30, 10, 5, 5, 5, 5]; // Level-wise bonus amounts
    $current_level = 1;

    while ($current_level <= count($levels)) {
        if (!$referredBy) break; // No more uplines

        // Fetch upline user data
        $query = "SELECT id, referCode, referredBy FROM sign_up WHERE referCode = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $referredBy);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $upline_user_id = $row['id'];
            $upline_referCode = $row['referCode'];
            $upline_referredBy = $row['referredBy'];

            // Add bonus to the upline's wallet
            $bonus_amount = $levels[$current_level - 1];
            $update_wallet_query = "UPDATE sign_up SET wallet_balance = wallet_balance + ? WHERE referCode = ?";
            $update_wallet_stmt = $conn->prepare($update_wallet_query);
            $update_wallet_stmt->bind_param("ds", $bonus_amount, $upline_referCode);
            $update_wallet_stmt->execute();

            // Record the transaction
            $transaction_query = "INSERT INTO transactions (user_id, refer_id, amount, type, description, update_at) VALUES (?, ?, ?, 'commission', ?, ?)";
            $transaction_stmt = $conn->prepare($transaction_query);
            $description = "লেভেল $current_level এফিলিয়েট বোনাস যুক্ত হয়েছে ";
            $transaction_stmt->bind_param("isdss", $upline_user_id, $user_refer, $bonus_amount, $description, $current_time);
            $transaction_stmt->execute();

            // Move to the next level upline
            $referredBy = $upline_referredBy;
            $current_level++;
        } else {
            break; // No more uplines
        }
    }
}

?>