<?php
include 'auth_check.php'; 
include 'db_connect.php';
$conn->set_charset('utf8mb4');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $action = $_POST['action'];

    // Step 1: Get the withdraw request info
    $stmt = $conn->prepare("SELECT * FROM withdraw_requests WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $request = $result->fetch_assoc();

        $user_id = $request['user_id'];
        $amount = $request['amount'];
        $payment_gateway = $request['payment_gateway'];

        // Step 2: If Approved, insert into transactions table
        if ($action === 'Approved') {
            $insert = $conn->prepare("INSERT INTO transactions (user_id, amount, payment_gateway, type, description, update_at) VALUES (?, ?, ?, 'withdraw', 'Withdraw Money Approved', NOW())");
            $insert->bind_param("ids", $user_id, $amount, $payment_gateway);
            $insert->execute();
        }

        // Step 3: Update withdraw_request table
        $update = $conn->prepare("UPDATE withdraw_requests SET status = ?, updated_at = NOW() WHERE id = ?");
        $update->bind_param("si", $action, $id);
        $update->execute();
    }


    header("Location: withdraw_request.php");
    exit();
}
?>
