<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$user_id = $_POST['user_id'] ?? null;
$action = $_POST['action'] ?? null; // 'approve' or 'reject'
$payment_gateway = $_POST['payment_gateway'] ?? null;
$current_time = $_POST['current_time'] ?? date("Y-m-d H:i:s"); // Default: Current time

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($user_id) && isset($action)) {
    
    if ($action !== 'Approved' && $action !== 'Rejected') {
        $response = [
            'status' => 'error',
            'message' => 'অবৈধ অ্যাকশন',
            'data' => null
        ];
        echo json_encode($response);
        exit;
    }

    // Check if the request exists and is pending
    $query = "SELECT * FROM withdraw_requests WHERE user_id = ? AND status = 'Pending'";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id); // Use the unique ID to identify the request
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $request = $result->fetch_assoc();
        $request_id = $request['id'];
        $amount = $request['amount'];

        if ($action === 'Approved') {
            // Add money to transactions table
            $insert_query = "INSERT INTO transactions (user_id, amount, payment_gateway, type, description, update_at) 
                             VALUES (?, ?, ?, 'withdraw', 'Withdraw Approved', ?)";
            $insert_stmt = $conn->prepare($insert_query);
            $insert_stmt->bind_param("idss", $request['user_id'], $amount, $payment_gateway, $current_time);

            if ($insert_stmt->execute()) {
                // Update request status using the unique ID
                $update_query = "UPDATE withdraw_requests SET status = ?, updated_at = ? WHERE id = ?";
                $update_stmt = $conn->prepare($update_query);
                $update_stmt->bind_param("ssi", $action, $current_time, $request_id);

                if ($update_stmt->execute()) {

                    $response['message'] = "রিকোয়েস্ট অনুমোদিত এবং টাকা যোগ করা হয়েছে";

                } else {

                    $response['message'] = "রিকোয়েস্ট আপডেট করতে ব্যর্থ";
                    
                }
            } else {

                $response['message'] = "টাকা যোগ করতে ব্যর্থ";
                
            }
        } elseif ($action === 'Rejected') {
            // Reject the request using the unique ID
            $update_query = "UPDATE withdraw_requests SET status = ?, updated_at = ? WHERE id = ?";
            $update_stmt = $conn->prepare($update_query);
            $update_stmt->bind_param("ssi", $action, $current_time, $request_id);

            if ($update_stmt->execute()) {

                $response['message'] = "রিকোয়েস্ট বাতিল করা হয়েছে";
                
            } else {

                $response['message'] = "রিকোয়েস্ট আপডেট করতে ব্যর্থ";
                
            }
        }
    } else {

        $response['message'] = "রিকোয়েস্ট পাওয়া যায়নি বা ইতিমধ্যে প্রক্রিয়াজাত করা হয়েছে";
        
    }
} else {

    $response['message'] = "অবৈধ ডেটা";
    
}

echo json_encode($response);
?>