<?php
include 'auth_check.php'; 
include 'db_connect.php';
$conn->set_charset('utf8mb4');

// ব্যানার আপলোড
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['banner'])) {
    $image = $_FILES['banner'];
    $redirect_url = $_POST['redirect_url'];

    $target_dir = "Banners/";
    if (!is_dir($target_dir)) mkdir($target_dir);

    $image_name = time() . "_" . basename($image["name"]);
    $target_file = $target_dir . $image_name;

    $image_url = "https://mrdeveloper.xyz/Rootva/RootvaAdmin/" . $target_file ;

    if (move_uploaded_file($image["tmp_name"], $target_file)) {
        $stmt = $conn->prepare("INSERT INTO banners (image_url, redirect_url) VALUES (?, ?)");
        $stmt->bind_param("ss", $image_url, $redirect_url);
        $stmt->execute();
    }
}

// ব্যানার ডিলিট
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $get = $conn->query("SELECT image_url FROM banners WHERE id = $id");
    $data = $get->fetch_assoc();
    if ($data) {
        unlink($data['image_url']); // সার্ভার থেকে ফাইল মুছে ফেলুন
        $conn->query("DELETE FROM banners WHERE id = $id");
    }
}

// ব্যানার তালিকা
$banners = $conn->query("SELECT * FROM banners ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Banner Manager</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <div class="container mt-4">
        <a href="index.php" class="btn btn-sm btn-outline-secondary mb-4">← ড্যাশবোর্ডে ফিরে যান</a>
        <h4 class="mb-4">🖼️ ব্যানার আপলোড</h4>
        <form method="POST" enctype="multipart/form-data" class="card p-4 mb-5 shadow-sm">
            <div class="mb-3">
                <label class="form-label">ব্যানার ছবি:</label>
                <input type="file" name="banner" accept="image/*" required class="form-control">
            </div>
            <div class="mb-3">
                <label class="form-label">Redirect URL (যেখানে ক্লিক করলে যাবে (Optional)):</label>
                <input type="url" name="redirect_url" class="form-control" placeholder="https://example.com">
            </div>
            <button type="submit" class="btn btn-primary">✅ আপলোড করুন</button>
        </form>

        <h5>📜 পূর্বের ব্যানারসমূহ:</h5>
        <div class="row">
            <?php while ($row = $banners->fetch_assoc()): ?>
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm">
                <img src="<?= $row['image_url'] ?>" class="card-img-top" alt="Banner" style="height: 180px; object-fit: cover;">
                <div class="card-body">
                    <?php if ($row['redirect_url']): ?>
                    <p class="card-text">
                        🔗 <a href="<?= $row['redirect_url'] ?>" target="_blank"><?= $row['redirect_url'] ?></a>
                    </p>
                    <?php endif; ?>
                    <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('আপনি কি ব্যানারটি ডিলিট করতে চান?')" class="btn btn-danger btn-sm">🗑️ ডিলিট</a>
                </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    </div>

</body>
</html>
