<?php
include 'auth_check.php'; 
include 'db_connect.php'; 
$conn->set_charset('utf8mb4');

$id = intval($_GET['id']);
$sql = "SELECT * FROM sign_up WHERE id = $id";
$result = $conn->query($sql);
$user = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = $_POST['status'];
    $stmt = $conn->prepare("UPDATE sign_up SET is_verified = ? WHERE id = ?");
    $stmt->bind_param("ii", $new_status, $id);
    $stmt->execute();
    header("Location: user_details.php?id=$id");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>ব্যবহারকারীর বিস্তারিত</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f0f2f5;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
            background: #fff;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        .profile-img {
            display: block;
            margin: 0 auto 20px;
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .info p {
            font-size: 16px;
        }
        .nid-img {
            width: 100%;
            max-width: 350px;
            border-radius: 10px;
            border: 1px solid #ddd;
            box-shadow: 0 0 8px rgba(0,0,0,0.05);
        }
    </style>
</head>
<body>

<div class="container">
    <h2 class="text-center mb-4">ব্যবহারকারীর বিস্তারিত তথ্য</h2>
    <a href="all_users.php" class="btn btn-sm btn-outline-secondary">← Back to All Users</a>

    <?php if ($user): ?>
        <img class="profile-img" src="<?= !empty($user['profile_pic_url']) ? $user['profile_pic_url'] : 'https://thumb.ac-illust.com/b1/b170870007dfa419295d949814474ab2_t.jpeg' ?>" alt="Profile Picture">

        <div class="info">
            <p><strong>নাম:</strong> <?= htmlspecialchars($user['name']) ?></p>
            <p><strong>মোবাইল:</strong> <?= htmlspecialchars($user['number']) ?></p>
            <p><strong>ইমেইল:</strong> <?= htmlspecialchars($user['email']) ?></p>
            <p><strong>ঠিকানা:</strong> <?= htmlspecialchars($user['address']) ?></p>
            <p><strong>লিঙ্গ:</strong> <?= htmlspecialchars($user['gender']) ?></p>
            <p><strong>রেফার কোড:</strong> <?= htmlspecialchars($user['referCode']) ?></p>
            <p><strong>রেফার করেছেন:</strong> <?= htmlspecialchars($user['referredBy']) ?></p>
            <p><strong>ওয়ালেট ব্যালেন্স:</strong> <?= number_format($user['wallet_balance'], 2) ?> টাকা</p>
            <p><strong>স্ট্যাটাস:</strong> 
                <?php
                    if ($user['is_verified'] == 0) echo '<span class="badge bg-danger">Unverified</span>';
                    elseif ($user['is_verified'] == 1) echo '<span class="badge bg-success">Verified</span>';
                    elseif ($user['is_verified'] == 2) echo '<span class="badge bg-warning">Pending</span>';
                    elseif ($user['is_verified'] == 3) echo '<span class="badge bg-primary">Demo Verified</span>';
                    else echo '<span class="badge bg-warning">Suspend</span>';
                ?>
            </p>

            <?php if ($user['is_verified'] == 2): ?>
                <p class="mt-3">
                    <a href="verification_requests.php" class="btn btn-outline-primary btn-sm mt-2">
                        আপডেট করতে এখানে ক্লিক করুন
                    </a>
                </p>
            <?php else: ?>
                <form method="post" class="mt-3">
                    <label><strong>স্ট্যাটাস পরিবর্তন করুন:</strong></label>
                    <select name="status" class="form-select mb-2" required>
                        <?php if ($user['is_verified'] == 0): ?>
                            <option value="0" selected>Unverified</option>
                            <option value="3">✅ Demo Verified</option>
                            <option value="4">🚫 Suspended</option>
                        <?php elseif ($user['is_verified'] == 1): ?>
                            <option value="1" selected>Verified</option>
                            <option value="4">🚫 Suspended</option>
                        <?php elseif ($user['is_verified'] == 3): ?>
                            <option value="3" selected>Demo Verified</option>
                            <option value="0">Unverified</option>
                        <?php elseif ($user['is_verified'] == 4): ?>
                            <option value="4" selected>🚫 Suspended</option>
                            <option value="0">Unverified</option>
                            <option value="1">Verified</option>
                            <option value="3">Demo Verified</option>
                        <?php endif; ?>
                    </select>
                    <button type="submit" class="btn btn-primary">আপডেট করুন</button>
                </form>
            <?php endif; ?>


            <p class="mt-4"><strong>তৈরি হয়েছে:</strong> <?= htmlspecialchars($user['created_at']) ?></p>
            <p><strong>ভেরিফাইড হয়েছে:</strong> <?= htmlspecialchars($user['verified_at']) ?></p>
        </div>
    <?php else: ?>
        <div class="alert alert-danger text-center">ব্যবহারকারী পাওয়া যায়নি।</div>
    <?php endif; ?>
</div>

</body>
</html>
