<?php
include 'auth_check.php';
include 'db_connect.php';
$conn->set_charset('utf8mb4');

if (!isset($_GET['id'])) {
    header('Location: all_complaints.php');
    exit;
}

$id = intval($_GET['id']);
$query = "SELECT * FROM complaints WHERE id = '$id'";
$result = $conn->query($query);

if ($result->num_rows == 0) {
    echo "<div class='alert alert-danger'>অভিযোগ খুঁজে পাওয়া যায়নি!</div>";
    exit;
}

$row = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>অভিযোগ বিস্তারিত</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h3 class="mb-4">অভিযোগ বিস্তারিত</h3>
        <div class="card">
            <div class="card-body">
                <table class="table table-bordered">
                    <tr><th>অভিযোগ ID</th><td><?php echo $row['id']; ?></td></tr>
                    <tr><th>নাম</th><td><?php echo $row['name']; ?></td></tr>
                    <tr><th>বয়স</th><td><?php echo $row['age']; ?></td></tr>
                    <tr><th>পিতার নাম</th><td><?php echo $row['father_name']; ?></td></tr>
                    <tr><th>মাতার নাম</th><td><?php echo $row['mother_name']; ?></td></tr>
                    <tr><th>স্বামী/স্ত্রীর নাম</th><td><?php echo $row['spouse_name']; ?></td></tr>
                    <tr><th>গ্রাম</th><td><?php echo $row['village']; ?></td></tr>
                    <tr><th>ডাকঘর</th><td><?php echo $row['post_office']; ?></td></tr>
                    <tr><th>থানা</th><td><?php echo $row['thana']; ?></td></tr>
                    <tr><th>জেলা</th><td><?php echo $row['district']; ?></td></tr>
                    <tr><th>ফোন নম্বর</th><td><?php echo $row['phone_number']; ?></td></tr>
                    <tr><th>অভিযোগের ধরন</th><td><?php echo $row['complaint_type']; ?></td></tr>
                    <tr><th>বিস্তারিত বিবরণ</th><td><?php echo nl2br($row['details']); ?></td></tr>
                    <tr><th>অভিযোগকারী নাম</th><td><?php echo $row['complainant_name']; ?></td></tr>
                    <tr><th>অভিযোগকারী ফোন</th><td><?php echo $row['complainant_phone']; ?></td></tr>
                    <tr><th>স্বাক্ষর</th>
                        <td>
                            <?php if (!empty($row['signature'])): ?>
                                <img src="<?php echo $row['signature']; ?>" alt="Signature" style="max-height: 100px;">
                            <?php else: ?>
                                <em>নেই</em>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr><th>স্ট্যাটাস</th>
                        <td><span class="badge bg-<?php
                            switch($row['status']) {
                                case 'approved': echo 'success'; break;
                                case 'rejected': echo 'danger'; break;
                                case 'investigating': echo 'warning'; break;
                                case 'complete': echo 'primary'; break;
                                default: echo 'secondary';
                            }
                        ?>"><?php echo $row['status']; ?></span></td>
                    </tr>
                    <tr><th>PDF লিঙ্ক</th>
                        <td>
                            <?php if (!empty($row['pdf_url'])): ?>
                                <a href="<?php echo $row['pdf_url']; ?>" target="_blank" class="btn btn-sm btn-outline-primary">ডাউনলোড করুন</a>
                            <?php else: ?>
                                <em>নেই</em>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr><th>পেমেন্ট অ্যামাউন্ট</th><td><?php echo $row['payment_amount']; ?> টাকা</td></tr>
                    <tr><th>গেটওয়ে</th><td><?php echo $row['payment_gateway']; ?></td></tr>
                    <tr><th>পেমেন্ট নাম্বার</th><td><?php echo $row['payment_number']; ?></td></tr>
                    <tr><th>লেনদেন ID</th><td><?php echo $row['transaction_id']; ?></td></tr>
                    <tr><th>তারিখ</th><td><?php echo $row['created_at']; ?></td></tr>
                </table>

                <a href="edit_complaint.php?id=<?php echo $row['id']; ?>" class="btn btn-warning">✏️ এডিট করুন</a>
                <a href="all_complaints.php" class="btn btn-secondary">← সকল অভিযোগে ফিরে যান</a>
            </div>
        </div>
    </div>
</body>
</html>
