<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_POST['user_id'] ?? null;
$amount = $_POST['amount'] ?? null;
$payment_gateway = $_POST['payment_gateway'] ?? null;

$response = [];

if (isset($user_id) && isset($amount) && $amount > 0 && in_array($payment_gateway, ['bkash', 'nagad', 'rocket', 'bank'])) {
    // Wallet balance update
    $update_query = "UPDATE sign_up SET wallet_balance = wallet_balance + ? WHERE id = ?";
    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("di", $amount, $user_id);

    if ($stmt->execute()) {
        // Record transaction
        $description = "Added $amount via $payment_gateway";
        $insert_transaction = "INSERT INTO transactions (user_id, amount, type, payment_gateway, description) VALUES (?, ?, 'add', ?, ?)";
        $stmt = $conn->prepare($insert_transaction);
        $stmt->bind_param("idds", $user_id, $amount, $payment_gateway, $description);

        if ($stmt->execute()) {
            $response['message'] = "টাকা সফলভাবে যোগ করা হয়েছে";
        } else {
            $response['message'] = "ট্রানজেকশন রেকর্ড করতে ব্যর্থ";
        }
    } else {
        $response['message'] = "ওয়ালেট আপডেট করতে ব্যর্থ";
    }
} else {
    $response['message'] = "অবৈধ ডেটা বা ভুল পেমেন্ট গেটওয়ে";
}

echo json_encode($response);
?>