<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

// ইনপুট গ্রহণ
$user_id = trim($_POST['user_id'] ?? '');
$title = trim($_POST['title'] ?? '');
$account_number = trim($_POST['account_number'] ?? '');
$amount = trim($_POST['amount'] ?? '');
$transaction_id = trim($_POST['transaction_id'] ?? '');
$payment_gateway = trim($_POST['payment_gateway'] ?? '');
$current_time = $_POST['current_time'] ?? date("Y-m-d H:i:s"); // Default: Current time

// রেসপন্স ভেরিয়েবল
$response = [];

// ভ্যালিডেশন
if (empty($user_id) || empty($amount) || empty($payment_gateway)) {
    $response['status'] = 'error';
    $response['message'] = "সবগুলো ফিল্ড পূরণ করুন";
    echo json_encode($response);
    exit;
}

if (!is_numeric($amount)) {
    $response['status'] = 'error';
    $response['message'] = "অবৈধ অ্যামাউন্ট";
    echo json_encode($response);
    exit;
}

// ডেটা সংরক্ষণ (Prepared Statement ব্যবহার)
$sql_insert = "INSERT INTO money_requests (user_id, title, account_number, amount, transaction_id, payment_gateway, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql_insert);

if ($stmt) {
    $stmt->bind_param("issdsss", $user_id, $title, $account_number, $amount, $transaction_id, $payment_gateway, $current_time);
    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = "রিকোয়েস্ট সফলভাবে সাবমিট হয়েছে";
    } else {
        $response['status'] = 'error';
        $response['message'] = "রিকোয়েস্ট সাবমিট করতে ব্যর্থ";
    }

    echo json_encode($response);
} else {
    $response['status'] = 'error';
    $response['message'] = "অবৈধ ডেটা";
    echo json_encode($response);
}

?>