<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

// ইনপুট গ্রহণ
$refer_id = trim($_POST['refer_id'] ?? '');
$title = trim($_POST['title'] ?? '');
$amount = trim($_POST['amount'] ?? '');
$payment_gateway = trim($_POST['payment_gateway'] ?? '');
$type = trim($_POST['type'] ?? '');

// রেসপন্স ভেরিয়েবল
$response = [];

// ভ্যালিডেশন
if (empty($refer_id) || empty($amount) || empty($payment_gateway)) {
    $response['status'] = 'error';
    $response['message'] = "সবগুলো ফিল্ড পূরণ করুন";
    echo json_encode($response);
    exit;
}

if (!is_numeric($amount)) {
    $response['status'] = 'error';
    $response['message'] = "অবৈধ অ্যামাউন্ট";
    echo json_encode($response);
    exit;
}

// ডেটা সংরক্ষণ (Prepared Statement ব্যবহার)
$sql_insert = "INSERT INTO transactions (refer_id, title, amount, payment_gateway, type) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql_insert);

if ($stmt) {
    $stmt->bind_param("ssdss", $refer_id, $title, $amount, $payment_gateway, $type);
    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = "পেমেন্ট যোগ সফল";
        $response['data'] = [
            'refer_id' => $refer_id,
            'title' => $title,
            'amount' => $amount,
            'payment_gateway' => $payment_gateway,
            'type' => $type
        ];
    } else {
        $response['status'] = 'error';
        $response['message'] = "ডেটা যোগ করতে ব্যর্থ";
    }
} else {
    $response['status'] = 'error';
    $response['message'] = "ডেটাবেস ত্রুটি";
}

// JSON ফরম্যাটে রেসপন্স রিটার্ন
echo json_encode($response);
?>