<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");

if (!isset($_POST['user_id'])) {
    echo json_encode(['error' => true, 'message' => 'User ID missing']);
    exit;
}

$user_id = intval($_POST['user_id']);
$bonus_type = 'monthly_salary';
$current_time = 'Y-m-d h:i A';

// Step 1: Get last bonus time
$last_time = '1970-01-01 00:00:00';
$stmt = $conn->prepare("SELECT MAX(created_at) as last_claim FROM bonus_tracker WHERE user_id = ? AND bonus_type = ?");
$stmt->bind_param("is", $user_id, $bonus_type);
$stmt->execute();
$res = $stmt->get_result();
if ($row = $res->fetch_assoc()) {
    if ($row['last_claim']) {
        $last_time = $row['last_claim'];
    }
}

// Step 2: Get Level 1 users
$level1 = [];
$level1_refer_codes = [];
$q1 = $conn->prepare("SELECT id, referCode FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
$q1->bind_param("i", $user_id);
$q1->execute();
$res1 = $q1->get_result();
while ($row = $res1->fetch_assoc()) {
    $level1[] = $row['id'];
    $level1_refer_codes[] = $row['referCode'];
}

// Step 3: Count verified Level 1 after last claim
$level1_verified = 0;
if (count($level1) > 0) {
    $placeholders1 = implode(',', array_fill(0, count($level1), '?'));
    $types1 = str_repeat('i', count($level1));
    $stmt1 = $conn->prepare("SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND verified_raw_time > ? AND user_id IN ($placeholders1)");
    $stmt1->bind_param("s" . $types1, $last_time, ...$level1);
    $stmt1->execute();
    $res = $stmt1->get_result();
    $level1_verified = $res->fetch_assoc()['cnt'];
}

// Step 4: Get Level 2 users
$level2 = [];
if (count($level1_refer_codes) > 0) {
    $placeholders2 = implode(',', array_fill(0, count($level1_refer_codes), '?'));
    $types2 = str_repeat('s', count($level1_refer_codes));
    $stmt2 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy IN ($placeholders2)");
    $stmt2->bind_param($types2, ...$level1_refer_codes);
    $stmt2->execute();
    $res2 = $stmt2->get_result();
    while ($row = $res2->fetch_assoc()) {
        $level2[] = $row['id'];
    }
}

// Step 5: Count verified Level 2 after last claim
$level2_verified = 0;
if (count($level2) > 0) {
    $placeholders3 = implode(',', array_fill(0, count($level2), '?'));
    $types3 = str_repeat('i', count($level2));
    $stmt3 = $conn->prepare("SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND verified_raw_time > ? AND user_id IN ($placeholders3)");
    $stmt3->bind_param("s" . $types3, $last_time, ...$level2);
    $stmt3->execute();
    $res3 = $stmt3->get_result();
    $level2_verified = $res3->fetch_assoc()['cnt'];
}

// Step 6: Eligibility check
if ($level1_verified >= 50 && $level2_verified >= 100) {
    // Give bonus
    $insert = $conn->prepare("INSERT INTO bonus_tracker (user_id, bonus_type, created_at) VALUES (?, ?, ?)");
    $insert->bind_param("iss", $user_id, $bonus_type, $current_time);
    if ($insert->execute()) {
        echo json_encode([
            'error' => false,
            'message' => 'Bonus granted successfully!',
            'level1_verified' => $level1_verified,
            'level2_verified' => $level2_verified
        ]);
    } else {
        echo json_encode(['error' => true, 'message' => 'Failed to insert bonus.']);
    }
} else {
    echo json_encode([
        'error' => true,
        'message' => 'Not eligible yet.',
        'level1_verified' => $level1_verified,
        'level2_verified' => $level2_verified
    ]);
}
?>
