<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db_connect.php';
header('Content-Type: application/json; charset=utf-8');
$conn->set_charset("utf8mb4");

date_default_timezone_set("Asia/Dhaka");
$created_at = date("Y-m-d H:i:s");

if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => 'User ID missing']);
    exit;
}

$user_id = intval($_GET['user_id']);
$bonus_type = 'spin_target';
$bonus_amount = 500.00;

// Step 1: Check if bonus already given
$check = $conn->prepare("SELECT id FROM bonus_tracker WHERE user_id = ? AND bonus_type = ?");
$check->bind_param("is", $user_id, $bonus_type);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode(['error' => 'Bonus already given']);
    exit;
}
$check->close();

// Step 2: Repeat the same logic as get_spin_progress to verify again

// Recalculate Level 1 and Level 2 verified users
$level1 = [];
$level1_codes = [];

$q1 = $conn->prepare("SELECT id, referCode FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
$q1->bind_param("i", $user_id);
$q1->execute();
$res1 = $q1->get_result();
while ($row = $res1->fetch_assoc()) {
    $level1[] = $row['id'];
    $level1_codes[] = $row['referCode'];
}
$q1->close();

if (count($level1) < 10) {
    echo json_encode(['error' => 'Not enough Level 1 referrals']);
    exit;
}

// Count verified in Level 1
$placeholders = implode(',', array_fill(0, count($level1), '?'));
$types = str_repeat('i', count($level1));
$params = $level1;

$stmt1 = $conn->prepare("SELECT COUNT(*) AS cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders)");
$stmt1->bind_param($types, ...$params);
$stmt1->execute();
$res = $stmt1->get_result();
$level1_verified = $res->fetch_assoc()['cnt'];
$stmt1->close();

if ($level1_verified < 10) {
    echo json_encode(['error' => 'Not enough verified Level 1']);
    exit;
}

// Level 2 referrals
$level2 = [];
if (count($level1_codes) > 0) {
    $placeholders2 = implode(',', array_fill(0, count($level1_codes), '?'));
    $types2 = str_repeat('s', count($level1_codes));
    $params2 = $level1_codes;

    $stmt2 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy IN ($placeholders2)");
    $stmt2->bind_param($types2, ...$params2);
    $stmt2->execute();
    $res2 = $stmt2->get_result();
    while ($row = $res2->fetch_assoc()) {
        $level2[] = $row['id'];
    }
    $stmt2->close();
}

if (count($level2) < 10) {
    echo json_encode(['error' => 'Not enough Level 2 referrals']);
    exit;
}

// Count verified in Level 2
$placeholders3 = implode(',', array_fill(0, count($level2), '?'));
$types3 = str_repeat('i', count($level2));
$params3 = $level2;

$stmt3 = $conn->prepare("SELECT COUNT(*) AS cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders3)");
$stmt3->bind_param($types3, ...$params3);
$stmt3->execute();
$res3 = $stmt3->get_result();
$level2_verified = $res3->fetch_assoc()['cnt'];
$stmt3->close();

if ($level2_verified < 10) {
    echo json_encode(['error' => 'Not enough verified Level 2']);
    exit;
}

// Step 3: Insert Bonus
$insert1 = $conn->prepare("INSERT INTO bonus_tracker (user_id, bonus_type, amount, created_at) VALUES (?, ?, ?, ?)");
$insert1->bind_param("isds", $user_id, $bonus_type, $bonus_amount, $created_at);
$insert1->execute();
$insert1->close();

// Step 4: Insert into Transactions
$type = 'income';
$payment_gateway = 'bonus';
$description = "🎁 Spin Target Bonus (Level1: $level1_verified, Level2: $level2_verified)";
$current_time = date("d-m-Y H:i A");

$insert2 = $conn->prepare("INSERT INTO transactions (user_id, amount, type, payment_gateway, description, created_at, update_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
$insert2->bind_param("dssssss", $user_id, $bonus_amount, $type, $payment_gateway, $description, $current_time, $current_time);
$insert2->execute();
$insert2->close();

echo json_encode(['success' => true, 'message' => "৳$bonus_amount Bonus Given!"]);
?>