<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$number = $_GET['number'] ?? null;

$response = [];

if ($number) {
    // SQL Injection থেকে বাঁচাতে number কে sanitize করা উচিত
    $stmt = $conn->prepare("SELECT password_updated_at FROM sign_up WHERE number = ?");
    $stmt->bind_param("s", $number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $response['password_updated_at'] = $row['password_updated_at'];
    } else {
        $response['error'] = "Number not found";
    }

    $stmt->close();
} else {
    $response['error'] = "Number is required";
}

$conn->close();

// Return JSON response
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
