<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);
include 'db_connect.php';
header("Content-Type: application/json; charset=UTF-8");

$user_id = $_GET['user_id'] ?? null;
if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "User ID is required"]);
    exit;
}

// Step 1: Get user's referCode
$stmt = $conn->prepare("SELECT referCode FROM sign_up WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($referCode);
$stmt->fetch();
$stmt->close();

if (!$referCode) {
    echo json_encode(["status" => "error", "message" => "User not found"]);
    exit;
}

// Step 2: Get Level 1 referred users
$level1 = [];
$level1Details = [];

$stmt = $conn->prepare("SELECT id, name, referCode FROM sign_up WHERE referredBy = ?");
$stmt->bind_param("s", $referCode);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $level1[] = $row;
}
$stmt->close();

$verifiedCount = 0;
$leaderCount = 0;
$silverCandidates = [];
$goldCandidates = [];
$diamondCandidates = [];
$topCandidates = [];

foreach ($level1 as $member) {
    $member_id = $member['id'];
    $member_name = $member['name'];
    $member_code = $member['referCode'];

    // Get level 2 users
    $stmt = $conn->prepare("SELECT id FROM sign_up WHERE referredBy = ?");
    $stmt->bind_param("s", $member_code);
    $stmt->execute();
    $result = $stmt->get_result();
    $l2Users = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $verifiedL2 = 0;
    foreach ($l2Users as $l2) {
        $stmt = $conn->prepare("SELECT COUNT(*) FROM verification_requests WHERE user_id = ? AND status = 'Approved'");
        $stmt->bind_param("i", $l2['id']);
        $stmt->execute();
        $stmt->bind_result($v);
        $stmt->fetch();
        $stmt->close();
        if ($v > 0) $verifiedL2++;
    }

    $isLeader = $verifiedL2 >= 15;
    if ($isLeader) {
        $leaderCount++;
        $silverCandidates[] = ["id" => $member_id, "name" => $member_name, "verified_referrals" => $verifiedL2, "is_leader" => true];
    }

    // Count if level 1 member is verified
    $stmt = $conn->prepare("SELECT COUNT(*) FROM verification_requests WHERE user_id = ? AND status = 'Approved'");
    $stmt->bind_param("i", $member_id);
    $stmt->execute();
    $stmt->bind_result($verifiedSelf);
    $stmt->fetch();
    $stmt->close();
    if ($verifiedSelf > 0) $verifiedCount++;

    $level1Details[] = [
        "id" => $member_id,
        "name" => $member_name,
        "verified_referrals" => $verifiedL2,
        "is_leader" => $isLeader
    ];
}

$remainingToLeader = max(0, 15 - $verifiedCount);

// Step 3: Check own orders
$stmt = $conn->prepare("SELECT COUNT(*) FROM orders WHERE user_id = ? AND order_status IN ('Confirmed', 'Delivered')");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($orderCount);
$stmt->fetch();
$stmt->close();

// Evaluate Silver Candidates
foreach ($silverCandidates as $candidate) {
    $subCode = null;
    $stmt = $conn->prepare("SELECT referCode FROM sign_up WHERE id = ?");
    $stmt->bind_param("i", $candidate['id']);
    $stmt->execute();
    $stmt->bind_result($subCode);
    $stmt->fetch();
    $stmt->close();

    // Count leaders under this member
    $stmt = $conn->prepare("SELECT id FROM sign_up WHERE referredBy = ?");
    $stmt->bind_param("s", $subCode);
    $stmt->execute();
    $result = $stmt->get_result();
    $subs = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $subLeaders = 0;
    foreach ($subs as $sub) {
        $sub_id = $sub['id'];
        $stmt = $conn->prepare("SELECT id FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
        $stmt->bind_param("i", $sub_id);
        $stmt->execute();
        $subresult = $stmt->get_result();
        $lvl2s = $subresult->fetch_all(MYSQLI_ASSOC);
        $stmt->close();

        $subLeader = 0;
        foreach ($lvl2s as $lvl2) {
            $stmt = $conn->prepare("SELECT COUNT(*) FROM verification_requests WHERE user_id = ? AND status = 'Approved'");
            $stmt->bind_param("i", $lvl2['id']);
            $stmt->execute();
            $stmt->bind_result($v);
            $stmt->fetch();
            $stmt->close();
            if ($v > 0) $subLeader++;
        }

        if ($subLeader >= 15) $subLeaders++;
    }

    if ($subLeaders >= 10) $goldCandidates[] = $candidate;
    if ($subLeaders >= 10 && $orderCount >= 3) $diamondCandidates[] = $candidate;
    if ($subLeaders >= 10 && $orderCount >= 10) $topCandidates[] = $candidate;
}

// Determine final reward
$reward = "None";
if ($verifiedCount >= 15) $reward = "Leader";
if ($leaderCount >= 10 && $orderCount >= 1) $reward = "Silver";
if (count($goldCandidates) >= 10 && $orderCount >= 3) $reward = "Gold";
if (count($diamondCandidates) >= 10 && $orderCount >= 5) $reward = "Diamond";
if (count($topCandidates) >= 10 && $orderCount >= 10) $reward = "Top";

// Final Output
echo json_encode([
    "status" => "success",
    "user_id" => $user_id,
    "reward" => $reward,
    "level1_summary" => [
        "total_referred" => count($level1),
        "verified" => $verifiedCount,
        "leaders" => $leaderCount,
        "remaining_to_leader" => $remainingToLeader
    ],
    "level1_details" => $level1Details,
    "silver_candidates" => $silverCandidates,
    "gold_candidates" => $goldCandidates,
    "diamond_candidates" => $diamondCandidates,
    "top_candidates" => $topCandidates
], JSON_PRETTY_PRINT);
?>
