<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

header('Content-Type: application/json');

// Input Check
if (!isset($_GET['user_id'])) {
    echo json_encode(["status" => "error", "message" => "❌ User ID missing."]);
    exit;
}

$user_id = intval($_GET['user_id']);
$bonus_type = 'spin_target';
$bonus_amount = 500.00;

// Step 1: Check if bonus already given
$check = $conn->prepare("SELECT id FROM bonus_tracker WHERE user_id = ? AND bonus_type = ?");
$check->bind_param("is", $user_id, $bonus_type);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode(["status" => "already_given", "message" => "❌ Bonus already given to this user."]);
    exit;
}

// Step 2: Get Level 1 referrals
$level1 = [];
$level1_refer_codes = [];
$q1 = $conn->prepare("SELECT id, referCode FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
$q1->bind_param("i", $user_id);
$q1->execute();
$res1 = $q1->get_result();

while ($row = $res1->fetch_assoc()) {
    $level1[] = $row['id'];
    $level1_refer_codes[] = $row['referCode'];
}

if (count($level1) < 10) {
    echo json_encode(["status" => "incomplete", "message" => "❌ Not enough Level 1 referrals.", "level1" => count($level1)]);
    exit;
}

// Step 3: Count Level 1 verified
$placeholders = implode(',', array_fill(0, count($level1), '?'));
$types = str_repeat('i', count($level1));
$params = $level1;

$stmt1 = $conn->prepare("SELECT COUNT(*) AS cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders)");
$stmt1->bind_param($types, ...$params);
$stmt1->execute();
$res = $stmt1->get_result();
$level1_verified = $res->fetch_assoc()['cnt'];

if ($level1_verified < 10) {
    echo json_encode(["status" => "incomplete", "message" => "❌ Not enough verified users in Level 1.", "level1_verified" => $level1_verified]);
    exit;
}

// Step 4: Get Level 2 referrals
$level2 = [];
if (count($level1_refer_codes) === 0) {
    echo json_encode(["status" => "incomplete", "message" => "❌ No Level 1 refer codes found."]);
    exit;
}
$placeholders2 = implode(',', array_fill(0, count($level1_refer_codes), '?'));
$types2 = str_repeat('s', count($level1_refer_codes));
$params2 = $level1_refer_codes;

$stmt2 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy IN ($placeholders2)");
$stmt2->bind_param($types2, ...$params2);
$stmt2->execute();
$res2 = $stmt2->get_result();
while ($row = $res2->fetch_assoc()) {
    $level2[] = $row['id'];
}

if (count($level2) < 10) {
    echo json_encode(["status" => "incomplete", "message" => "❌ Not enough Level 2 referrals.", "level2" => count($level2)]);
    exit;
}

// Step 5: Count Level 2 verified
$placeholders3 = implode(',', array_fill(0, count($level2), '?'));
$types3 = str_repeat('i', count($level2));
$params3 = $level2;

$stmt3 = $conn->prepare("SELECT COUNT(*) AS cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders3)");
$stmt3->bind_param($types3, ...$params3);
$stmt3->execute();
$res3 = $stmt3->get_result();
$level2_verified = $res3->fetch_assoc()['cnt'];

if ($level2_verified < 10) {
    echo json_encode(["status" => "incomplete", "message" => "❌ Not enough verified users in Level 2.", "level2_verified" => $level2_verified]);
    exit;
}

// ✅ Target met → Give bonus

// Step 6: Save in bonus_tracker
$insert1 = $conn->prepare("INSERT INTO bonus_tracker (user_id, bonus_type, amount) VALUES (?, ?, ?)");
$insert1->bind_param("isd", $user_id, $bonus_type, $bonus_amount);
$insert1->execute();

// Step 7: Insert in transactions table
$type = 'income';
$payment_gateway = 'bonus';
$description = "🎁 Spin Target Bonus (Level1: $level1_verified, Level2: $level2_verified)";
$created_at = date("Y-m-d H:i:s");

$insert2 = $conn->prepare("INSERT INTO transactions (user_id, amount, type, payment_gateway, description, created_at, update_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
$insert2->bind_param("dssssss", $user_id, $bonus_amount, $type, $payment_gateway, $description, $created_at, $created_at);
$insert2->execute();

echo json_encode([
    "status" => "success",
    "message" => "✅ Spin Target Bonus of ৳$bonus_amount added to User ID: $user_id",
    "amount" => $bonus_amount,
    "level1_verified" => $level1_verified,
    "level2_verified" => $level2_verified
]);
?>
