<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json; charset=utf-8');
include 'db_connect.php';

$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

$user_id = $_POST['user_id'] ?? $_GET['user_id'] ?? 0;

if ($user_id <= 0) {
    echo json_encode(['error' => true, 'message' => 'Invalid user ID']);
    exit;
}

try {
    $conn->begin_transaction();

    // 1. ইউজারের বর্তমান স্পিন ইনফো নিয়ে আসা
    $stmt = $conn->prepare("SELECT spin_balance, claimed FROM wheel_spin_info WHERE user_id = ? FOR UPDATE");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $spin_info = $stmt->get_result()->fetch_assoc();

    if (!$spin_info) {
        throw new Exception("User spin info not found");
    }

    // 2. ভ্যালিডেশন চেক
    if ($spin_info['spin_balance'] < 500) {
        throw new Exception("Minimum ৳500 required to claim");
    }

    if ($spin_info['claimed'] == 1) {
        throw new Exception("Already claimed");
    }

    // 3. টাকা ট্রান্সফার লজিক (এখানে আপনার পেমেন্ট সিস্টেম যোগ করুন)
    $payment_gateway = "Spin Bonus";
    $transaction_id = "SPIN-" . time() . "-" . $user_id;
    $amount = 500;
    
    // 4. ট্রানজেকশন টেবিলে রেকর্ড যোগ করা
    $stmt = $conn->prepare("INSERT INTO transactions 
                          (user_id, refer_id, amount, type, payment_gateway, description, created_at) 
                          VALUES (?, NULL, ?, 'income', ?, 'Spin bonus claim', NOW())");
    $stmt->bind_param("ids", $user_id, $amount, $payment_gateway);
    $stmt->execute();

    // 5. স্পিন ইনফো আপডেট করা
    $stmt = $conn->prepare("UPDATE wheel_spin_info 
                          SET spin_balance = 0, 
                              claimed = 1 
                          WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();

    $conn->commit();

    echo json_encode([
        'error' => false,
        'message' => 'Successfully claimed ৳500',
        'transaction_id' => $transaction_id,
        'new_balance' => 0,
        'claimed' => true
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
?>