<?php
error_reporting(E_ALL);
ini_set('display_errors',1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

$date = date("Y-m-d", strtotime("yesterday"));
$start = $date . " 00:00:00";
$end = $date . " 23:59:59";

$today_date_only = date("Y-m-d");

$query = "
    SELECT 
        s.referredBy AS refer_id, 
        r.id AS user_id, 
        r.name, 
        r.profile_pic_url, 
        COUNT(*) AS total
    FROM verification_requests vr
    JOIN sign_up s ON vr.user_id = s.id
    JOIN sign_up r ON s.referredBy = r.referCode
    WHERE vr.status = 'Approved'
      AND vr.verified_raw_time BETWEEN ? AND ?
    GROUP BY s.referredBy
    HAVING total >= 4
    ORDER BY total DESC
    LIMIT 1
";

$stmt = $conn->prepare($query);

if (!$stmt) {
    die("Query Prepare Failed: " . $conn->error);
}

$stmt->bind_param("ss", $start, $end);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $user_id = $row['user_id'];
    $refer_id = $row['refer_id'];
    $total = $row['total'];

    // ✅ Check if bonus already given to this user for this date
    $bonus_check = $conn->prepare("
        SELECT id FROM transactions 
        WHERE user_id = ? AND payment_gateway = 'Daily Bonus' AND DATE(date) = ?
    ");
    $bonus_check->bind_param("is", $user_id, $today_date_only);
    $bonus_check->execute();
    $bonus_result = $bonus_check->get_result();

    if ($bonus_result->num_rows > 0) {
        echo "⚠️ User ID $user_id already received the daily bonus on $date.";
    } else {
        // ✅ Insert new bonus
        $amount = 100.00;
        $type = 'income';
        $payment_gateway = 'Daily Bonus';
        $description = "🎉 Daily Winner Bonus for $total verifications on $date";
        $current_time = date("d-m-Y h:i A");
        $created_at = date("Y-m-d H:i:s");

        $insert = $conn->prepare("INSERT INTO transactions (user_id, refer_id, amount, type, payment_gateway, description, update_at, created_at, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $insert->bind_param("isdssssss", $user_id, $refer_id, $amount, $type, $payment_gateway, $description, $current_time, $current_time, $created_at);
        $insert->execute();

        echo "✅ Bonus transaction added for User ID: $user_id with $total verifications.";
    }
} else {
    echo "⚠️ No user verified 4 or more accounts yesterday.";
}
?>
