<?php

mb_internal_encoding("UTF-8");
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'fpdf/vendor/autoload.php'; // যদি fpdf/ এর ভিতরে vendor থাকে

use setasign\Fpdi\Fpdi;


// ডাটা (তুমি চাইলে DB থেকেও নিতে পারো)
$name = "মোঃ আব্দুল হাকিম";
$father_name = "আবুল কাশেম";
$address = "সদর, নড়াইল";
$phone = "017XXXXXXXX";
$complaint = "আমার প্রতিবেশী জোর করে জমি দখল করছে।";

// PDF তৈরি শুরু
$pdf = new Fpdi();
$pdf->AddPage();
$pdf->setSourceFile("অভিযোগ পত্র.pdf");

// প্রথম পৃষ্ঠা ইমপোর্ট
$templateId = $pdf->importPage(1);
$pdf->useTemplate($templateId);

// লেখার জন্য ফন্ট ও পজিশন সেট
$pdf->AddFont('kalpurush', '', 'kalpurush.php'); // যদি বাংলা ফন্ট ইউজ করো
$pdf->SetFont('kalpurush', '', 12); // অথবা 'Arial'

// ডাটা বসানো (X, Y পজিশন তোমার PDF অনুযায়ী ঠিক করতে হবে)
$pdf->SetXY(30, 60);
$pdf->Write(10, $name);

$pdf->SetXY(30, 70);
$pdf->Write(10, $father_name);

$pdf->SetXY(30, 80);
$pdf->Write(10, $address);

$pdf->SetXY(30, 90);
$pdf->Write(10, $phone);

$pdf->SetXY(30, 120);
$pdf->MultiCell(150, 7, $complaint);

// আউটপুট
$pdf->Output("I", "completed-form.pdf");

?>
