<?php

include 'db_connect.php';
$conn->set_charset("utf8mb4");
$timezone = "Asia/Dhaka";
$conn->query("SET time_zone = '$timezone'");
header("Content-Type: application/json; charset=utf-8");

$referCode = trim($_POST['referCode'] ?? '');

$response = [];

if (!empty($referCode)) {
    $downlines = getDownlineUsers($referCode);
    $response['refer'] = $downlines;
    $response['message'] = "ডেটা সফলভাবে লোড হয়েছে";
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);

// Function to get all downline users recursively
function getDownlineUsers($referCode) {
    global $conn;
    $users = [];

    // Get direct referrals
    $query = "SELECT * FROM sign_up WHERE referredBy = ? ORDER BY id DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $referCode);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $level = getUserLevel($row['referCode']);
            $row['level'] = $level; // Add level to the user data
            $users[] = $row;

            // Recursively get downlines of this user
            $downlines = getDownlineUsers($row['referCode']);
            $users = array_merge($users, $downlines);
        }
    }

    return $users;
}

// Function to calculate user level
function getUserLevel($referCode) {
    global $conn;
    $level = 0;

    while (true) {
        $query = "SELECT referredBy FROM sign_up WHERE referCode = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $referCode);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $referredBy = $row['referredBy'];

            if ($referredBy == null || $referredBy == "") {
                break; // No more uplines
            }

            $referCode = $referredBy;
            $level++;
        } else {
            break; // User not found
        }
    }

    return $level;
}
?>