<?php
header("Content-Type: application/json; charset=utf-8");

// কনফিগারেশন ফাইল ইনক্লুড
include 'db_connect.php';
$conn->set_charset('utf8mb4');

// ইনপুট গ্রহণ
$number = trim($_POST['number'] ?? '');

// রেসপন্স ভেরিয়েবল
$response = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($number)) {
    // ভ্যালিডেশন
    if (!is_numeric($number)) {
        $response['status'] = 'error';
        $response['message'] = "অবৈধ ফোন নম্বর";
        echo json_encode($response);
        exit;
    }

    // ইউজারের তথ্য নিয়ে আসুন (Prepared Statement ব্যবহার)
    $query = "SELECT * FROM sign_up WHERE number = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // শুধু একটি ইউজারের তথ্য নিয়ে আসুন
        $user = $result->fetch_assoc();

        // সফল রেসপন্স
        $response['status'] = 'success';
        $response['message'] = "ইউজার তথ্য সফলভাবে পাওয়া গেছে";
        $response['data'] = $user; // একটি সিঙ্গেল অবজেক্ট
    } else {
        $response['status'] = 'error';
        $response['message'] = "ইউজার পাওয়া যায়নি";
    }

    echo json_encode($response);

    // ডেটাবেস কানেকশন বন্ধ করুন
    $stmt->close();
    $conn->close();
} else {
    $response['status'] = 'error';
    $response['message'] = "অবৈধ ডেটা";
    echo json_encode($response);
}
?>