<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$date = date('Y-m-d');

// আজকের তারিখে দেওয়া বোনাসগুলোর তালিকা আনা হচ্ছে
$sql = "
    SELECT t.*, u.name, u.number 
    FROM transactions t
    JOIN sign_up u ON u.id = t.user_id
    WHERE t.type = 'income' AND t.payment_gateway = 'bonus' AND DATE(t.created_at) = ?
    ORDER BY t.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $date);
$stmt->execute();
$result = $stmt->get_result();

$winners = [];

while ($row = $result->fetch_assoc()) {
    $winners[] = [
        'id'         => $row['id'],
        'user_id'    => $row['user_id'],
        'name'       => $row['name'],
        'number'      => $row['number'],
        'refer_id'   => $row['refer_id'],
        'amount'     => $row['amount'],
        'description'=> $row['description'],
        'created_at' => $row['created_at'],
    ];
}

echo json_encode([
    'status' => true,
    'date' => $date,
    'winners' => $winners
], JSON_UNESCAPED_UNICODE);

?>
