<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

$date = date('Y-m-d');
$start_time = $date . ' 00:00:00';
$end_time = $date . ' 23:59:59';

$sql = "
SELECT s.referredBy AS referrer_id, r.name, r.profile_pic_url, COUNT(*) AS total_verifications
FROM verification_requests vr
JOIN sign_up s ON vr.user_id = s.id
JOIN sign_up r ON s.referredBy = r.referCode
WHERE vr.status = 'Approved'
AND vr.verified_raw_time BETWEEN ? AND ?
GROUP BY s.referredBy
ORDER BY total_verifications DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $start_time, $end_time);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode(['status' => true, 'ranking' => $data]);
?>
