<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$response = [];
$user_id = $_GET['user_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($user_id)) {
    
    $query = "SELECT id, amount, type, refer_id, description, date, payment_gateway, update_at FROM transactions 
        WHERE user_id = ? AND type IN ('income', 'commission') ORDER BY id DESC ";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $transactions = [];
    $total_amount = 0;

    while ($row = $result->fetch_assoc()) {
        $total_amount += $row['amount'];
        $transactions[] = $row;
    }

    // Prepare response
    $response = [
        'status' => 'success',
        'message' => 'Income report fetched successfully',
        'income_history' => $transactions
    ];
} else {
    $response = [
        'status' => 'error',
        'message' => 'Invalid data',
        'income_history' => null
    ];
}

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>
