<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$response = [];
$user_id = $_GET['user_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($user_id)) {
    function getIncomeDetails($conn, $user_id, $condition) {
        $query = "SELECT id, refer_id, amount, payment_gateway, type, description, date, update_at FROM transactions 
                  WHERE user_id = ? AND type IN ('income', 'commission') $condition ORDER BY id DESC";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $transactions = [];
        $total_amount = 0;
    
        while ($row = $result->fetch_assoc()) {
            $row['amount'] = number_format((float)$row['amount'], 2, '.', '');
            $total_amount += (float)$row['amount'];
            $transactions[] = $row;
        }
    
        $total_amount = number_format((float)$total_amount, 2, '.', '');
    
        return ['total' => $total_amount, 'details' => $transactions];
    }
    

    // Get today's income
    $today = date('Y-m-d');
    $today_data = getIncomeDetails($conn, $user_id, "AND DATE(date) = '$today'");

    // Get yesterday's income
    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $yesterday_data = getIncomeDetails($conn, $user_id, "AND DATE(date) = '$yesterday'");

    // Get last 7 days income (including today)
    $last_7_days = date('Y-m-d', strtotime('-6 days')); // today + past 6 days = 7 total
    $week_data = getIncomeDetails($conn, $user_id, "AND DATE(date) BETWEEN '$last_7_days' AND '$today'");

    // Get last 30 days income (including today)
    $last_30_days = date('Y-m-d', strtotime('-29 days'));
    $month_data = getIncomeDetails($conn, $user_id, "AND DATE(date) BETWEEN '$last_30_days' AND '$today'");

    // Get last 365 days income (including today)
    $last_365_days = date('Y-m-d', strtotime('-364 days'));
    $year_data = getIncomeDetails($conn, $user_id, "AND DATE(date) BETWEEN '$last_365_days' AND '$today'");

    // Get total (lifetime) income
    $total_data = getIncomeDetails($conn, $user_id, "");


    // Prepare response
    $response = [
        'status' => 'success',
        'message' => 'Income report fetched successfully',
        'data' => [
            'today' => $today_data,
            'yesterday' => $yesterday_data,
            'week' => $week_data,
            'month' => $month_data,
            'year' => $year_data,
            'total' => $total_data
        ]
    ];
} else {
    $response = [
        'status' => 'error',
        'message' => 'Invalid data',
        'data' => null
    ];
}

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>
