<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$response = [];

$user_id = $_GET['user_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($user_id)) {
    $query = "SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $notifications = [];
        while ($row = $result->fetch_assoc()) {
            $notifications[] = $row;
        }
        $response = [
            'status' => 'success',
            'message' => 'Notifications fetched successfully',
            'data' => $notifications
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'No notifications found',
            'data' => []
        ];
    }
} else {
    $response = [
        'status' => 'error',
        'message' => 'Invalid data',
        'data' => null
    ];
}

echo json_encode($response);
?>