<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset('utf8mb4');

$user_id = $_GET['user_id'] ?? null;

$response = [];

if (isset($user_id)) {
    $query = "SELECT name, number, address, email, profile_pic_url, gender, referCode, is_verified, wallet_balance, created_at, verified_at FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        $response['data'] = $user;
        $response['message'] = "ডেটা সফলভাবে লোড হয়েছে";
    } else {
        $response['message'] = "ইউজার খুঁজে পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>