<?php
ob_start();
include 'db_connect.php';
$conn->set_charset("utf8mb4");
ob_clean();
header("Content-Type: application/json; charset=utf-8");

$start_time = microtime(true);

// Input
$referCode = $_GET['referCode'] ?? null;
$isUpdated = isset($_GET['isUpdated']) && $_GET['isUpdated'] === 'true';
$limit = $isUpdated ? intval($_GET['limit'] ?? 20) : 0;
$offset = $isUpdated ? intval($_GET['offset'] ?? 0) : 0;

$response = [];

if (!$referCode) {
    $response['message'] = "অবৈধ ডেটা";
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

$searchReferCode = $_GET['searchReferCode'] ?? null;

// যদি নির্দিষ্ট ইউজার সার্চ করা হয়
if ($searchReferCode) {
    $allUsers = getAllReferralsRecursiveWithLevel($conn, $referCode, 7);
    $foundUser = null;

    foreach ($allUsers as $user) {
        if ($user['referCode'] === $searchReferCode) {
            $foundUser = $user;
            break;
        }
    }

    if ($foundUser) {
        $response['referUsers'] = [$foundUser];
        $response['message'] = "সার্চ সফল হয়েছে";
    } else {
        $response['referUsers'] = [];
        $response['message'] = "❌ এই রেফার কোডটি আপনার ট্রিতে খুঁজে পাওয়া যায়নি";
    }

    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}


// Recursive function with level, optimized fields only
function getAllReferralsRecursiveWithLevel($conn, $referCode, $maxLevel = 7) {
    $allUsers = [];
    $queue = [$referCode];
    $currentLevel = 1;

    while (!empty($queue) && $currentLevel <= $maxLevel) {
        $nextQueue = [];

        $placeholders = implode(',', array_fill(0, count($queue), '?'));
        $types = str_repeat('s', count($queue));
        $stmt = $conn->prepare("SELECT id, name, number, referCode, is_verified, profile_pic_url, verified_at, created_at FROM sign_up WHERE referredBy IN ($placeholders)");
        $stmt->bind_param($types, ...$queue);
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()) {
            $row['level'] = $currentLevel;
            $allUsers[] = $row;
            $nextQueue[] = $row['referCode'];
        }

        $queue = $nextQueue;
        $currentLevel++;
    }

    // DESC order
    usort($allUsers, fn($a, $b) => $b['id'] <=> $a['id']);
    return $allUsers;
}

// OLD level-wise system
function getAllReferralsByLevel($conn, $referCode, $level) {
    $users = [];

    if ($level == 1) {
        $stmt = $conn->prepare("SELECT id, name, number, referCode, is_verified, profile_pic_url, verified_at, created_at FROM sign_up WHERE referredBy = ?");
        $stmt->bind_param("s", $referCode);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $row['level'] = $level;
            $users[] = $row;
        }
    } else {
        $prev_users = getAllReferralsByLevel($conn, $referCode, $level - 1);
        foreach ($prev_users as $prev_user) {
            $stmt = $conn->prepare("SELECT id, name, number, referCode, is_verified, profile_pic_url, verified_at, created_at FROM sign_up WHERE referredBy = ?");
            $stmt->bind_param("s", $prev_user['referCode']);
            $stmt->execute();
            $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) {
                $row['level'] = $level;
                $users[] = $row;
            }
        }
    }

    return $users;
}

// Main logic
try {
    if ($isUpdated) {
        $allUsers = getAllReferralsRecursiveWithLevel($conn, $referCode, 7);
        $paginatedUsers = array_slice($allUsers, $offset, $limit);

        $response['data'] = [['users' => $paginatedUsers]];
        $response['total'] = count($allUsers);
        $response['hasMore'] = ($offset + $limit) < count($allUsers);
    } else {
        $levels = [];
        for ($level = 1; $level <= 7; $level++) {
            $users = getAllReferralsByLevel($conn, $referCode, $level);
            if (!empty($users)) {
                $levels[] = [
                    'level' => $level,
                    'users' => $users
                ];
            }
        }
        $response['data'] = $levels;
    }

    $response['message'] = "ডেটা সফলভাবে লোড হয়েছে";
} catch (Exception $e) {
    $response['message'] = "সার্ভার ত্রুটি: " . $e->getMessage();
}

$end_time = microtime(true);
$response['load_time'] = round($end_time - $start_time, 4) . " sec";

$json = json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
if ($json === false) {
    $json = json_encode([
        "message" => "JSON Encode ত্রুটি: " . json_last_error_msg(),
        "raw_data_length" => strlen(json_encode($response))
    ]);
}

echo $json;
?>
