<?php
include 'db_connect.php';
$conn->set_charset('utf8mb4');
header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// ✅ User ID POST বা GET থেকে নেওয়া
$user_id = '';
if (isset($_POST['user_id'])) {
    $user_id = $_POST['user_id'];
} elseif (isset($_GET['user_id'])) {
    $user_id = $_GET['user_id'];
}

if (empty($user_id)) {
    echo json_encode(['success' => false, 'message' => 'User ID not provided']);
    exit;
}

$now = date('Y-m-d H:i:s');

// ✅ User যেগুলা already complete করেছে সেগুলা বাদ দাও
$stmt = $conn->prepare("SELECT * FROM review_job 
                        WHERE locked_by IS NULL 
                        AND (scheduled_at IS NULL OR scheduled_at <= ?) 
                        ORDER BY id DESC");
$stmt->bind_param("s", $now);
$stmt->execute();
$result = $stmt->get_result();

$jobs = array();
while ($row = mysqli_fetch_assoc($result)) {
    $jobs[] = $row;
}

echo json_encode($jobs);
?>
