<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => true, 'message' => 'User ID missing']);
    exit;
}

$user_id = intval($_GET['user_id']);

// Step 1: Last claim time (monthly_salary)
$last_claim_time = '2000-01-01 00:00:00';
$q = $conn->prepare("SELECT MAX(created_at) as last_claim FROM bonus_tracker WHERE user_id = ? AND bonus_type = 'monthly_salary'");
$q->bind_param("i", $user_id);
$q->execute();
$res = $q->get_result();
if ($row = $res->fetch_assoc()) {
    $last_claim_time = $row['last_claim'] ?? $last_claim_time;
}
$q->close();

// Step 2: Get all Level 1 referrals (new + old)
$level1 = [];
$q1 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
$q1->bind_param("i", $user_id);
$q1->execute();
$res1 = $q1->get_result();
while ($row = $res1->fetch_assoc()) {
    $level1[] = $row['id'];
}
$q1->close();

// Step 3: Get verified Level 1 after last claim (optional, for stats)
$level1_verified_ids = [];
if (count($level1) > 0) {
    $placeholders = implode(',', array_fill(0, count($level1), '?'));
    $types = str_repeat('i', count($level1));
    $query = "SELECT user_id FROM verification_requests WHERE status = 'Approved' AND verified_raw_time > ? AND user_id IN ($placeholders)";
    $stmt = $conn->prepare($query);
    $params = array_merge([$last_claim_time], $level1);

    $refs = [];
    $types_str = "s" . $types;
    foreach ($params as $key => $value) {
        $refs[$key] = &$params[$key];
    }
    call_user_func_array([$stmt, 'bind_param'], array_merge([$types_str], $refs));

    $stmt->execute();
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $level1_verified_ids[] = $row['user_id'];
    }
    $stmt->close();
}

$level1_verified = count($level1_verified_ids);

// Step 4: Count active Level 1s (those who referred at least 1 verified user after last claim)
$level1_active = 0;
$level2_ids_all = [];

foreach ($level1 as $l1_id) {
    $q2 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
    $q2->bind_param("i", $l1_id);
    $q2->execute();
    $res2 = $q2->get_result();
    $sub_ref_ids = [];
    while ($r = $res2->fetch_assoc()) {
        $sub_ref_ids[] = $r['id'];
    }
    $q2->close();

    if (count($sub_ref_ids) > 0) {
        $ph = implode(',', array_fill(0, count($sub_ref_ids), '?'));
        $types2 = str_repeat('i', count($sub_ref_ids));
        $q3 = $conn->prepare("SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND verified_raw_time > ? AND user_id IN ($ph)");
        $params = array_merge([$last_claim_time], $sub_ref_ids);

        $refs2 = [];
        $types2_str = "s" . $types2;
        foreach ($params as $key => $value) {
            $refs2[$key] = &$params[$key];
        }
        call_user_func_array([$q3, 'bind_param'], array_merge([$types2_str], $refs2));

        $q3->execute();
        $res3 = $q3->get_result();
        $verified_count = $res3->fetch_assoc()['cnt'];
        $q3->close();

        if ($verified_count > 0) {
            $level1_active++;
        }

        $level2_ids_all = array_merge($level2_ids_all, $sub_ref_ids);
    }
}

// Step 5: Count Level 2 verified after last claim
if (count($level2_ids_all) > 0) {
    $placeholders = implode(',', array_fill(0, count($level2_ids_all), '?'));
    $sql = "SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND verified_raw_time > ? AND user_id IN ($placeholders)";
    $stmt = $conn->prepare($sql);

    $types = "s" . str_repeat('i', count($level2_ids_all));
    $params = array_merge([$last_claim_time], $level2_ids_all);

    $refs = [];
    foreach ($params as $key => $value) {
        $refs[$key] = &$params[$key];
    }

    call_user_func_array([$stmt, 'bind_param'], array_merge([$types], $refs));

    $stmt->execute();
    $result = $stmt->get_result();
    $level2_verified = $result->fetch_assoc()['cnt'];
    $stmt->close();
} else {
    $level2_verified = 0;
}

// Step 6: Check own orders after last claim
$stmt = $conn->prepare("SELECT COUNT(*) FROM orders WHERE user_id = ? AND order_status = 'Delivered' AND created_at > ?");
$stmt->bind_param("is", $user_id, $last_claim_time);
$stmt->execute();
$stmt->bind_result($orderCount);
$stmt->fetch();
$stmt->close();

// Step 7: Eligibility Check
$eligible = (
    $level1_verified >= 50 &&
    $level2_verified >= 100 &&
    $level1_active >= 10 &&
    $orderCount >= 1
);

// Step 8: Bonus claim logic (commented out)

// Final Response
echo json_encode([
    'level1_verified' => $level1_verified,
    'level1_active' => $level1_active,
    'level2_verified' => $level2_verified,
    'eligible' => $eligible,
    'bonus_claimed' => false,
    'total_orders' => $orderCount
]);
