<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => true, 'message' => 'User ID missing']);
    exit;
}

$user_id = intval($_GET['user_id']);

// latest salary request status get করা হচ্ছে
$stmt = $conn->prepare("SELECT status FROM salary_requests WHERE user_id = ? AND request_type = 'monthly_salary' ORDER BY requested_at DESC LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($status);
if ($stmt->fetch()) {
    echo json_encode(['status' => $status]);
} else {
    // যদি কোন request না থাকে, তাহলে status 'None' ধরে নাও
    echo json_encode(['status' => 'None']);
}
$stmt->close();
?>
