<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");

if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => true, 'message' => 'User ID missing']);
    exit;
}

$user_id = intval($_GET['user_id']);

// Step 1: Get Level 1 referrals
$level1 = [];
$level1_refer_codes = [];

$q1 = $conn->prepare("SELECT id, referCode FROM sign_up WHERE referredBy = (SELECT referCode FROM sign_up WHERE id = ?)");
$q1->bind_param("i", $user_id);
$q1->execute();
$res1 = $q1->get_result();

while ($row = $res1->fetch_assoc()) {
    $level1[] = $row['id'];
    $level1_refer_codes[] = $row['referCode'];
}

// Step 2: Count verified Level 1
$level1_verified = 0;
if (count($level1) > 0) {
    $placeholders = implode(',', array_fill(0, count($level1), '?'));
    $types = str_repeat('i', count($level1));
    $stmt = $conn->prepare("SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders)");
    $stmt->bind_param($types, ...$level1);
    $stmt->execute();
    $res = $stmt->get_result();
    $level1_verified = $res->fetch_assoc()['cnt'];
}

// Step 3: Get Level 2 referrals
$level2 = [];
if (count($level1_refer_codes) > 0) {
    $placeholders2 = implode(',', array_fill(0, count($level1_refer_codes), '?'));
    $types2 = str_repeat('s', count($level1_refer_codes));
    $stmt2 = $conn->prepare("SELECT id FROM sign_up WHERE referredBy IN ($placeholders2)");
    $stmt2->bind_param($types2, ...$level1_refer_codes);
    $stmt2->execute();
    $res2 = $stmt2->get_result();
    while ($row = $res2->fetch_assoc()) {
        $level2[] = $row['id'];
    }
}

// Step 4: Count verified Level 2
$level2_verified = 0;
if (count($level2) > 0) {
    $placeholders3 = implode(',', array_fill(0, count($level2), '?'));
    $types3 = str_repeat('i', count($level2));
    $stmt3 = $conn->prepare("SELECT COUNT(*) as cnt FROM verification_requests WHERE status = 'Approved' AND user_id IN ($placeholders3)");
    $stmt3->bind_param($types3, ...$level2);
    $stmt3->execute();
    $res3 = $stmt3->get_result();
    $level2_verified = $res3->fetch_assoc()['cnt'];
}

// Step 5: Check if bonus already given
$bonus_type = 'spin_target';
$check = $conn->prepare("SELECT id FROM bonus_tracker WHERE user_id = ? AND bonus_type = ?");
$check->bind_param("is", $user_id, $bonus_type);
$check->execute();
$check->store_result();
$already_given = $check->num_rows > 0;

$eligible = ($level1_verified >= 15 && $level2_verified >= 15 && !$already_given);

echo json_encode([
    'level1_verified' => $level1_verified,
    'level2_verified' => $level2_verified,
    'eligible' => $eligible
]);
?>
