<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_GET['user_id'] ?? null;

$response = [];

if ($user_id) {
    // Withdraw এর জন্য extra check সহ transactions আনবো
    $query = "
        SELECT t.*
        FROM transactions t
        WHERE t.user_id = ?
        AND (
            t.type != 'withdraw'
            OR (
                t.type = 'withdraw'
                AND (
                    t.description = 'Withdraw Request Approved'
                )
            )
        )
        ORDER BY t.id DESC
    ";


    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $transactions = [];
    while ($row = $result->fetch_assoc()) {
        $transactions[] = $row;
    }

    if (!empty($transactions)) {
        $response['transactions'] = $transactions;
    } else {
        $response['message'] = "কোনো ট্রানজেকশন পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
