<?php

include 'db_connect.php';
$conn->set_charset("utf8mb4");
$timezone = "Asia/Dhaka";
$conn->query("SET time_zone = '$timezone'");
header("Content-Type: application/json; charset=utf-8");

$referCode = trim($_POST['referCode'] ?? '');

$response = [];

if (!empty($referCode)) {
    // Get user details
    $query = "SELECT * FROM sign_up WHERE referCode = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $referCode);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        $referredBy = $user['referredBy'];

        if (!empty($referredBy)) {
            // Get upline details
            $uplineQuery = "SELECT * FROM sign_up WHERE referCode = ?";
            $uplineStmt = $conn->prepare($uplineQuery);
            $uplineStmt->bind_param("s", $referredBy);
            $uplineStmt->execute();
            $uplineResult = $uplineStmt->get_result();

            if ($uplineResult->num_rows > 0) {
                $uplineUser = $uplineResult->fetch_assoc();
                $response['user'] = $uplineUser;
                $response['message'] = "আপলাইনের তথ্য সফলভাবে লোড হয়েছে";
            } else {
                $response['message'] = "আপলাইন পাওয়া যায়নি";
            }
        } else {
            $response['message'] = "এই ইউজারের কোন আপলাইন নেই";
        }
    } else {
        $response['message'] = "ইউজার পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>