<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_POST['user_id'] ?? null;

$response = [];

if (isset($user_id)) {
    // Calculate total balance from transactions
    $query = "
        SELECT 
            SUM(CASE 
                WHEN type IN ('add', 'commission', 'income') THEN amount 
                ELSE 0 
            END) -
            SUM(CASE 
                WHEN type IN ('withdraw', 'payment') THEN amount 
                ELSE 0 
            END) AS total_balance
        FROM transactions
        WHERE user_id = ?
    ";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $totalBalance = $row['total_balance'] ?? 0;

        // Update wallet balance in the database
        $updateQuery = "UPDATE sign_up SET wallet_balance = ? WHERE id = ?";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bind_param("di", $totalBalance, $user_id);

        if ($updateStmt->execute()) {
            $response['message'] = "ব্যালেন্স সফলভাবে আপডেট হয়েছে";
            $response['wallet_balance'] = $totalBalance;
        } else {
            $response['message'] = "ব্যালেন্স আপডেট ব্যর্থ";
        }
    } else {
        $response['message'] = "কোনো ট্রানজেকশন পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>