<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

$today = date("Y-m-d");
$dayOfWeek = date("w"); // 0 = Sunday, 6 = Saturday

if ($dayOfWeek == 6) {
    // আজ শনিবার, নতুন সপ্তাহ শুরু
    $startOfWeek = $today;
} else {
    // আজ শনিবার নয়, সর্বশেষ শনিবার খুঁজুন
    $startOfWeek = date("Y-m-d", strtotime("last saturday", strtotime($today)));
}

$endOfWeek = date("Y-m-d", strtotime($startOfWeek . " +6 days"));

$startTime = $startOfWeek . " 00:00:00";
$endTime = $endOfWeek . " 23:59:59";

$sql = "
SELECT s.referredBy AS referrer_id, r.name, r.profile_pic_url, COUNT(*) AS total_verifications
FROM verification_requests vr
JOIN sign_up s ON vr.user_id = s.id
JOIN sign_up r ON s.referredBy = r.referCode
WHERE vr.status = 'Approved'
AND vr.verified_raw_time BETWEEN ? AND ?
GROUP BY s.referredBy
ORDER BY total_verifications DESC
";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die(json_encode([
        "status" => false,
        "error" => "SQL Error: " . $conn->error
    ]));
}

$stmt->bind_param("ss", $startTime, $endTime);
if (!$stmt->execute()) {
    die(json_encode([
        "status" => false,
        "error" => "Execute failed: " . $stmt->error
    ]));
}

$result = $stmt->get_result();
$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode([
    "status" => true,
    "start_of_week" => $startOfWeek,
    "end_of_week" => $endOfWeek,
    "ranking" => $data
]);
?>