<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

// Weekly time range calculation
$today = date('Y-m-d');
$weekday = date('w'); // Sunday = 0, Saturday = 6
$startOfWeek = date('Y-m-d 06:00:00', strtotime('last Saturday'));
$endOfWeek = date('Y-m-d 23:59:59', strtotime('this Friday'));

$sql = "
WITH RECURSIVE referral_tree AS (
    SELECT s.id AS user_id, s.referredBy AS parent_id, 1 AS level
    FROM sign_up s
    WHERE s.referredBy IS NOT NULL

    UNION ALL

    SELECT s2.id, s2.referredBy, rt.level + 1
    FROM sign_up s2
    JOIN referral_tree rt ON s2.referredBy = rt.user_id
)

SELECT
    rt.parent_id AS user_id,
    s.name,
    s.profile_pic_url,
    COUNT(v.id) AS total_verifications
FROM referral_tree rt
JOIN sign_up s ON rt.parent_id = s.id
JOIN verification_requests v ON v.user_id = rt.user_id
WHERE rt.level = 1
  AND v.status = 'Approved'
  AND v.verified_raw_time BETWEEN ? AND ?
GROUP BY rt.parent_id
HAVING total_verifications >= 20
ORDER BY total_verifications DESC
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $startOfWeek, $endOfWeek);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

$response = [
    'status' => true,
    'start_of_week' => $startOfWeek,
    'end_of_week' => $endOfWeek,
    'ranking' => $data
];

echo json_encode($response);
?>
