<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

if (!isset($_GET['week_start_date'])) {
    echo json_encode(['status' => false, 'message' => 'Week start date is required', 'winner' => []]);
    exit;
}

$week_start_date = $_GET['week_start_date'];
$week_end_date = date('Y-m-d', strtotime($week_start_date . ' +6 days'));

$start_time = $week_start_date . ' 00:00:00';
$end_time = $week_end_date . ' 23:59:59';

$sql = "
    SELECT 
        s.referredBy AS refer_id, 
        r.id AS user_id, 
        r.name, 
        r.profile_pic_url, 
        COUNT(*) AS total_verifications
    FROM verification_requests vr
    JOIN sign_up s ON vr.user_id = s.id
    JOIN sign_up r ON s.referredBy = r.referCode
    WHERE vr.status = 'Approved'
      AND vr.verified_raw_time BETWEEN ? AND ?
    GROUP BY s.referredBy
    HAVING total_verifications >= 20  -- সাপ্তাহিক টার্গেট ২০ ভেরিফিকেশন
    ORDER BY total_verifications DESC
    LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $start_time, $end_time);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Always return winner as array, even if empty
echo json_encode([
    'status' => true, 
    'winner' => $data,
    'week_info' => [
        'start_date' => $week_start_date,
        'end_date' => $week_end_date
    ]
]);
?>