<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("Asia/Dhaka");

$current_time = date('Y-m-d H:i:s');

// ইনপুট গ্রহণ
$name = $_POST['name'] ?? null;
$number = $_POST['number'] ?? null;
$password = $_POST['password'] ?? null;
$referred_by = $_POST['referredBy'] ?? null;
$created_at = $_POST['created_at'] ?? null;

$response = [];

if (isset($name) && isset($number) && isset($password)) {

    // যদি referred_by ফাঁকা না হয়, তাহলে রেফার কোড যাচাই করুন
    if (!empty($referred_by)) {
        $check_ref_sql = "SELECT * FROM sign_up WHERE referCode = ?";
        $stmt = $conn->prepare($check_ref_sql);
        $stmt->bind_param("s", $referred_by);
        $stmt->execute();
        $check_ref_result = $stmt->get_result();

        if ($check_ref_result->num_rows == 0) {
            // ভুল রেফার কোড
            $response['message'] = "রেফার কোডটি সঠিক নয়";
            echo json_encode($response);
            exit;
        }
    }


    // মোবাইল নম্বর চেক (Prepared Statement ব্যবহার)
    $sql_number_check = "SELECT * FROM sign_up WHERE number = ?";
    $stmt = $conn->prepare($sql_number_check);
    $stmt->bind_param("s", $number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows <= 0) {
        // পাসওয়ার্ড হ্যাশ করা
        //$hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // রেফারেল কোড তৈরি
        $refer_code = str_pad(rand(0, 999999), 6, "0", STR_PAD_LEFT);

        // ডেটা সংরক্ষণ (Prepared Statement ব্যবহার)
        $sql_insert = "INSERT INTO sign_up (name, number, password, referCode, referredBy, created_at) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        $stmt->bind_param("ssssss", $name, $number, $password, $refer_code, $referred_by, $created_at);

        if ($stmt->execute()) {
            $new_user_id = $conn->insert_id;

            // যদি কোনো রেফারার থাকে, তাহলে কমিশন ডিস্ট্রিবিউট করুন
            if (!empty($referred_by)) {
                $query = "SELECT id FROM sign_up WHERE referCode = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("s", $referred_by);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    $referrer = $result->fetch_assoc();
                    $referrer_id = $referrer['id'];

                    // কমিশন ডিস্ট্রিবিউট করুন
                    distributeReferralCommission($referrer_id, $new_user_id);
                }
            }

            $response['message'] = "রেজিস্ট্রেশন সফল";

            // password_updated_at আনুন
            $get_time_stmt = $conn->prepare("SELECT password_updated_at FROM sign_up WHERE id = ?");
            $get_time_stmt->bind_param("i", $new_user_id);
            $get_time_stmt->execute();
            $get_time_result = $get_time_stmt->get_result();

            if ($get_time_result->num_rows > 0) {
                $time_row = $get_time_result->fetch_assoc();
                $response['password_updated_at'] = $time_row['password_updated_at'];
            }

        } else {
            $response['message'] = "রেজিস্ট্রেশন ব্যর্থ";
        }
    } else {
        $response['message'] = "মোবাইল নম্বরটি ইতিমধ্যে ব্যবহৃত হয়েছে";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);

// ফাংশন: লেভেল-ভিত্তিক কমিশন ডিস্ট্রিবিউট করা
function distributeReferralCommission($referrer_id, $new_user_id) {
    global $conn;

    $levels = [
        1 => 60, // Level 1: 70 টাকা
        2 => 30, // Level 2: 30 টাকা
        3 => 10, // Level 3: 10 টাকা
        4 => 5,  // Level 4: 5 টাকা
        5 => 5,  // Level 5: 5 টাকা
        6 => 5,  // Level 6: 5 টাকা
        7 => 5   // Level 7: 5 টাকা
    ];

    $current_level = 1;
    $user_id = $referrer_id;

    while ($current_level <= 7) {
        $query = "SELECT referredBy FROM sign_up WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $referrer = $result->fetch_assoc();
            $referrer_id = $referrer['referredBy'];

            if ($referrer_id) {
                // কমিশন দিন
                $amount = $levels[$current_level];
                addReferralCommission($user_id, $amount, $current_level, $new_user_id);

                $user_id = $referrer_id; // পরবর্তী লেভেলের জন্য আপডেট করুন
            } else {
                break; // আর কোনো রেফারার নেই
            }
        } else {
            break; // ডেটাবেস থেকে কোনো ডেটা পাওয়া যায়নি
        }

        $current_level++;
    }
}

// ফাংশন: কমিশন যোগ করা
function addReferralCommission($user_id, $amount, $level, $new_user_id) {
    global $conn;
    $description = "Level $level referral commission for user ID $new_user_id";

    $query = "INSERT INTO referral_commissions (user_id, level, amount, description) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("iids", $user_id, $level, $amount, $description);

    if ($stmt->execute()) {
        error_log("Commission Inserted for User ID $user_id at Level $level");
    } else {
        error_log("Error inserting commission: " . $stmt->error);
    }
}
?>