<?php
header('Content-Type: application/json');
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

$user_id = intval($_POST['user_id'] ?? 0);

if (!$user_id) {
    echo json_encode(['success' => false, 'message' => 'User ID missing']);
    exit;
}

// Check already applied
$stmt = $conn->prepare("SELECT * FROM salary_requests WHERE user_id = ? AND request_type = 'monthly_salary' AND status = 'Pending'");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode(['success' => false, 'message' => 'You have already applied. Please wait for admin approval.']);
    exit;
}

// Insert new request
$insert = $conn->prepare("INSERT INTO salary_requests (user_id) VALUES (?)");
$insert->bind_param("i", $user_id);
$inserted = $insert->execute();

echo json_encode([
    'success' => $inserted,
    'message' => $inserted ? 'Your application has been submitted!' : 'Failed to submit application.'
]);
?>
