<?php
error_reporting(E_ALL);
ini_set('display_errors',1);
include 'db_connect.php';
header("Content-Type: application/json");

$my_refer_code = $_GET['my_refer_code'] ?? '';
$search_refer_code = $_GET['search_refer_code'] ?? '';

$response = [];

if ($my_refer_code == '' || $search_refer_code == '') {
    echo json_encode(["error" => "missing parameter"]);
    exit;
}

// Step 1: Find Level 1 Users
$stmt = $conn->prepare("SELECT referCode FROM sign_up WHERE referredBy = ?");
$stmt->bind_param("s", $my_refer_code);
$stmt->execute();
$result = $stmt->get_result();

$level1 = [];
while ($row = $result->fetch_assoc()) {
    $level1[] = $row['referCode'];
}

// Step 2: Find Level 2 Users (refer_by in level1)
$level2 = [];
if (!empty($level1)) {
    $in  = str_repeat('?,', count($level1) - 1) . '?';
    $types = str_repeat('s', count($level1));
    $stmt2 = $conn->prepare("SELECT referCode FROM sign_up WHERE referredBy IN ($in)");
    $stmt2->bind_param($types, ...$level1);
    $stmt2->execute();
    $result2 = $stmt2->get_result();

    while ($row2 = $result2->fetch_assoc()) {
        $level2[] = $row2['referCode'];
    }
}

// Step 3: Merge and Check
$all_my_tree = array_merge($level1, $level2);

if (in_array($search_refer_code, $all_my_tree)) {
    // Found in your tree — get user info
    $stmt3 = $conn->prepare("SELECT * FROM sign_up WHERE referCode = ?");
    $stmt3->bind_param("s", $search_refer_code);
    $stmt3->execute();
    $result3 = $stmt3->get_result();

    if ($referUser = $result3->fetch_assoc()) {
        echo json_encode($referUser);
        exit;
    }
}

echo json_encode(["message" => "এই রেফার কোড আপনার টিমে নেই বা পাওয়া যায়নি।"]);
