<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

// ইনপুট গ্রহণ
$name = $_POST['name'] ?? null;
$number = $_POST['number'] ?? null;
$password = $_POST['password'] ?? null;
$referred_by = $_POST['referredBy'] ?? null;

// রেফারেল কোড তৈরি
$refer_code = str_pad(rand(0, 999999), 6, "0", STR_PAD_LEFT);

// রেসপন্স ভেরিয়েবল
$response = [];

if (isset($name) && isset($number) && isset($password)) {
    // মোবাইল নম্বর চেক (Prepared Statement ব্যবহার)
    $sql_number_check = "SELECT * FROM sign_up WHERE number = ?";
    $stmt = $conn->prepare($sql_number_check);
    $stmt->bind_param("s", $number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows <= 0) {
        // পাসওয়ার্ড হ্যাশ করা
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // ডেটা সংরক্ষণ (Prepared Statement ব্যবহার)
        $sql_insert = "INSERT INTO sign_up (name, number, password, referCode, referredBy) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        $stmt->bind_param("sssss", $name, $number, $hashed_password, $refer_code, $referred_by);

        if ($stmt->execute()) {
            $response['message'] = "রেজিস্ট্রেশন সফল";
        } else {
            $response['message'] = "রেজিস্ট্রেশন ব্যর্থ";
        }
    } else {
        $response['message'] = "মোবাইল নম্বরটি ইতিমধ্যে ব্যবহৃত হয়েছে";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

// JSON ফরম্যাটে রেসপন্স রিটার্ন
echo json_encode($response);
?>