<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

// ইনপুট গ্রহণ
$name = $_POST['name'] ?? null;
$number = $_POST['number'] ?? null;
$password = $_POST['password'] ?? null;
$referred_by = $_POST['referredBy'] ?? null;

// রেফারেল কোড তৈরি
$refer_code = str_pad(rand(0, 999999), 6, "0", STR_PAD_LEFT);

// রেসপন্স ভেরিয়েবল
$response = [];

if (isset($name) && isset($number) && isset($password)) {
    // মোবাইল নম্বর চেক (Prepared Statement ব্যবহার)
    $sql_number_check = "SELECT * FROM sign_up WHERE number = ?";
    $stmt = $conn->prepare($sql_number_check);
    $stmt->bind_param("s", $number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows <= 0) {
        // পাসওয়ার্ড হ্যাশ করা
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // ডেটা সংরক্ষণ (Prepared Statement ব্যবহার)
        $sql_insert = "INSERT INTO sign_up (name, number, password, referCode, referredBy) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        $stmt->bind_param("sssss", $name, $number, $hashed_password, $refer_code, $referred_by);

        if ($stmt->execute()) {
            $new_user_id = $conn->insert_id; // নতুন ইউজারের ID পান

            // যদি কোনো রেফারার থাকে, তাহলে কমিশন ডিস্ট্রিবিউট করুন
            if (!empty($referred_by)) {
                $query = "SELECT id FROM sign_up WHERE referCode = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("s", $referred_by);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    $referrer = $result->fetch_assoc();
                    $referrer_id = $referrer['id'];

                    // ডাইরেক্ট রেফারাল কমিশন দিন
                    addDirectReferralCommission($referrer_id, 70); // $10 ডাইরেক্ট কমিশন

                    // লেভেল-ভিত্তিক কমিশন ডিস্ট্রিবিউট করুন
                    distributeReferralCommission($referrer_id, 30); // $10 লেভেল-ভিত্তিক কমিশন
                }
            }

            $response['message'] = "রেজিস্ট্রেশন সফল";
        } else {
            $response['message'] = "রেজিস্ট্রেশন ব্যর্থ";
        }
    } else {
        $response['message'] = "মোবাইল নম্বরটি ইতিমধ্যে ব্যবহৃত হয়েছে";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

// JSON ফরম্যাটে রেসপন্স রিটার্ন
echo json_encode($response);

// ফাংশন: ডাইরেক্ট রেফারাল কমিশন যোগ করা
function addDirectReferralCommission($referrer_id, $amount) {
    global $conn;
    $description = "Direct referral commission";
    $level = 1;

    // Get referCode from user ID
    $query = "SELECT referCode FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $referrer_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $refer_code = $row['referCode'];

        // Insert into referral_commissions
        $query = "INSERT INTO referral_commissions (refer_id, level, commission_amount, description) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("sids", $refer_code, $level, $amount, $description);
        $stmt->execute();
    }
}

// ফাংশন: লেভেল-ভিত্তিক কমিশন ডিস্ট্রিবিউট করা
function distributeReferralCommission($user_id, $amount) {
    global $conn;
    $max_levels = 7; // সর্বোচ্চ লেভেল
    $current_level = 1;

    while ($current_level <= $max_levels) {
        // Get referredBy from user ID
        $query = "SELECT referredBy FROM sign_up WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $referrer = $result->fetch_assoc();
            $referrer_id = $referrer['referredBy'];

            if ($referrer_id) {
                // Calculate commission amount
                $commission_amount = $amount * (0.5 / $current_level);

                // Add level-wise commission
                addLevelWiseCommission($referrer_id, $commission_amount, $current_level);

                $user_id = $referrer_id; // Move to the next level
            } else {
                break; // No more referrer
            }
        } else {
            break; // No data found
        }

        $current_level++;
    }
}

// ফাংশন: লেভেল-ভিত্তিক কমিশন যোগ করা
function addLevelWiseCommission($user_id, $amount, $level) {
    global $conn;
    $description = "Level $level referral commission";

    // Get referCode from user ID
    $query = "SELECT referCode FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $refer_code = $row['referCode'];

        // Insert into referral_commissions
        $query = "INSERT INTO referral_commissions (refer_id, level, commission_amount, description) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("sids", $refer_code, $level, $amount, $description);
        $stmt->execute();
    }
}
?>