<?php
error_reporting(E_ALL);
ini_set('dispay_errors', 1);
include 'db_connect.php';
$conn->set_charset('utf8mb4');
date_default_timezone_set('Asia/Dhaka');

// Input from app
$user_id = $_POST['user_id'];
$job_id = $_POST['job_id'];
$proof_message = $_POST['proof_message'];
$proof_image_url = $_POST['proof_image_url']; // optional image proof

$current_time = date('d-m-Y h:i A');

// Step 1: Check if already submitted
$check = $conn->prepare("SELECT * FROM microjob_submissions WHERE worker_user_id = ? AND job_id = ?");
$check->bind_param("ii", $user_id, $job_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    echo json_encode(["status" => "error", "message" => "You have already completed this job."]);
    exit;
}

// Step 2: Get job details
$jobQuery = $conn->prepare("SELECT * FROM microjobs WHERE id = ?");
$jobQuery->bind_param("i", $job_id);
$jobQuery->execute();
$jobResult = $jobQuery->get_result();
$job = $jobResult->fetch_assoc();

if (!$job || $job['remaining_target'] <= 0) {
    echo json_encode(["status" => "error", "message" => "This job is no longer available."]);
    exit;
}

// Step 3: Save proof
$insert = $conn->prepare("INSERT INTO microjob_submissions (worker_user_id, job_id, proof_message, proof_image_url) VALUES (?, ?, ?, ?)");
$insert->bind_param("iiss", $user_id, $job_id, $proof_message, $proof_image_url);
$insert->execute();

// Step 4: Update remaining_target
$conn->query("UPDATE microjobs SET remaining_target = remaining_target - 1 WHERE id = $job_id");

// Step 5: Add transaction
$amount = $job['amount_per_worker'];
$type = "income";
$payment_gateway = "Microjob";
$description = "Earned from microjob: " . $job['title'];
$created_at = date("Y-m-d H:i:s");

$trans = $conn->prepare("INSERT INTO transactions (user_id, amount, type, payment_gateway, description, update_at, created_at, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$trans->bind_param("idssssss", $user_id, $amount, $type, $payment_gateway, $description, $current_time, $created_at, $created_at);
$trans->execute();

echo json_encode(["status" => "success", "message" => "Job completed and reward added."]);
?>
