<?php
header("Content-Type: application/json; charset=utf-8");
include 'db_connect.php';
$conn->set_charset("utf8mb4");

$user_id = $_POST['user_id'] ?? null;
$amount = $_POST['amount'] ?? null;
$payment_gateway = trim($_POST['payment_gateway'] ?? '');
$account_number = trim($_POST['account_number'] ?? '');
$current_time = $_POST['current_time'] ?? date("Y-m-d H:i:s");

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $user_id && $amount && $payment_gateway && $account_number) {
    if (!is_numeric($amount) || $amount <= 249) {
        echo json_encode(['status' => 'error', 'message' => "অবৈধ অ্যামাউন্ট"]);
        exit;
    }

    $fee = $amount * 0.02;
    $net_amount = $amount - $fee;

    // Step 1: Withdraw Request Entry
    $query = "INSERT INTO withdraw_requests (user_id, amount, net_amount, fee, payment_gateway, account_number, status, created_at) VALUES (?, ?, ?, ?, ?, ?, 'Pending', ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("idddsss", $user_id, $amount, $net_amount, $fee, $payment_gateway, $account_number, $current_time);

    if ($stmt->execute()) {
        // Step 2: Insert into Transactions as Pending
        $insert = $conn->prepare("INSERT INTO transactions (user_id, amount, payment_gateway, type, description, update_at) VALUES (?, ?, ?, 'withdraw', 'Withdraw Request Pending', ?)");
        $insert->bind_param("idss", $user_id, $amount, $payment_gateway, $current_time);
        $insert->execute();

        $response['status'] = 'success';
        $response['message'] = "রিকোয়েস্ট সফলভাবে সাবমিট হয়েছে";
    } else {
        $response['status'] = 'error';
        $response['message'] = "রিকোয়েস্ট সাবমিট করতে ব্যর্থ";
    }
} else {
    $response['status'] = 'error';
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>